/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.configuration;

import java.util.List;
import lombok.Generated;
import org.jetlinks.community.notify.DefaultNotifierManager;
import org.jetlinks.community.notify.NotifierManager;
import org.jetlinks.community.notify.NotifyConfigManager;
import org.jetlinks.community.notify.StaticNotifyConfigManager;
import org.jetlinks.community.notify.StaticTemplateManager;
import org.jetlinks.community.notify.configuration.CompositeNotifyConfigManager;
import org.jetlinks.community.notify.configuration.CompositeTemplateManager;
import org.jetlinks.community.notify.configuration.StaticNotifyProperties;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.core.event.EventBus;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={StaticNotifyProperties.class})
@Generated
public class NotifierAutoConfiguration {
    @Bean
    public StaticNotifyConfigManager staticNotifyConfigManager(StaticNotifyProperties properties) {
        return new StaticNotifyConfigManager(properties);
    }

    @Bean
    @Primary
    public NotifyConfigManager notifyConfigManager(List<NotifyConfigManager> managers) {
        return new CompositeNotifyConfigManager(managers);
    }

    @Bean
    public StaticTemplateManager staticTemplateManager(StaticNotifyProperties properties) {
        return new StaticTemplateManager(properties);
    }

    @Bean
    @Primary
    public TemplateManager templateManager(List<TemplateManager> managers) {
        return new CompositeTemplateManager(managers);
    }

    @Bean
    @ConditionalOnMissingBean(value={NotifierManager.class})
    public DefaultNotifierManager notifierManager(EventBus eventBus, NotifyConfigManager configManager) {
        return new DefaultNotifierManager(eventBus, configManager);
    }
}

