/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.configuration;

import java.util.List;
import javax.annotation.Nonnull;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifyConfigManager;
import org.jetlinks.community.notify.NotifyType;
import reactor.core.publisher.Mono;

public class CompositeNotifyConfigManager
implements NotifyConfigManager {
    private final List<NotifyConfigManager> managers;

    @Override
    @Nonnull
    public Mono<NotifierProperties> getNotifyConfig(@Nonnull NotifyType notifyType, @Nonnull String configId) {
        Mono mono = null;
        for (NotifyConfigManager manager : this.managers) {
            if (mono == null) {
                mono = manager.getNotifyConfig(notifyType, configId);
                continue;
            }
            mono = mono.switchIfEmpty(manager.getNotifyConfig(notifyType, configId));
        }
        return mono == null ? Mono.empty() : mono;
    }

    public CompositeNotifyConfigManager(List<NotifyConfigManager> managers) {
        this.managers = managers;
    }
}

