/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.jetlinks.community.notify.Notifier;
import org.jetlinks.community.notify.NotifierEventDispatcher;
import org.jetlinks.community.notify.NotifierManager;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifierProvider;
import org.jetlinks.community.notify.NotifyConfigManager;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DefaultNotifierManager
implements NotifierManager,
BeanPostProcessor,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(DefaultNotifierManager.class);
    private final Map<String, Map<String, NotifierProvider>> providers = new ConcurrentHashMap<String, Map<String, NotifierProvider>>();
    private Map<String, Notifier> notifiers = new ConcurrentHashMap<String, Notifier>();
    private NotifyConfigManager configManager;
    private EventBus eventBus;

    public DefaultNotifierManager(EventBus eventBus, NotifyConfigManager manager) {
        this.configManager = manager;
        this.eventBus = eventBus;
    }

    protected Mono<NotifierProperties> getProperties(NotifyType notifyType, String id) {
        return this.configManager.getNotifyConfig(notifyType, id);
    }

    @Override
    public Mono<Void> reload(String id) {
        return this.doReload(id).then(this.eventBus.publish("/_sys/notifier/reload", (Object)id)).then();
    }

    private Mono<String> doReload(String id) {
        log.debug("reload notifer config {}", (Object)id);
        return Mono.justOrEmpty((Object)this.notifiers.remove(id)).flatMap(Notifier::close).thenReturn((Object)id);
    }

    @Nonnull
    public Mono<Notifier> createNotifier(NotifierProperties properties) {
        return Mono.justOrEmpty(this.providers.get(properties.getType())).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u901a\u77e5\u7c7b\u578b:" + properties.getType()))).flatMap(map -> Mono.justOrEmpty(map.get(properties.getProvider()))).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u670d\u52a1\u5546:" + properties.getProvider()))).flatMap(notifierProvider -> notifierProvider.createNotifier(properties)).map(notifier -> new NotifierEventDispatcher(this.eventBus, notifier)).flatMap(notifier -> Mono.justOrEmpty((Object)this.notifiers.put(properties.getId(), (Notifier)notifier)).flatMap(Notifier::close).thenReturn(notifier));
    }

    @Nonnull
    public Mono<Notifier> getNotifier(@Nonnull NotifyType type, @Nonnull String id) {
        return Mono.justOrEmpty((Object)this.notifiers.get(id)).switchIfEmpty(Mono.defer(() -> this.getProperties(type, id).flatMap(this::createNotifier)));
    }

    public void registerProvider(NotifierProvider provider) {
        this.providers.computeIfAbsent(provider.getType().getId(), ignore -> new ConcurrentHashMap()).put(provider.getProvider().getId(), provider);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof NotifierProvider) {
            this.registerProvider((NotifierProvider)bean);
        }
        return bean;
    }

    public void run(String ... args) throws Exception {
        this.eventBus.subscribe(Subscription.builder().subscriberId("notifier-loader").topics(new String[]{"/_sys/notifier/reload"}).justBroker().build(), String.class).flatMap(id -> this.doReload((String)id).onErrorResume(err -> {
            log.error("reload notifer config error", err);
            return Mono.empty();
        })).subscribe();
    }
}

