/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.mqtt.gateway.device.session;

import java.time.Duration;
import org.jetlinks.community.gateway.monitor.DeviceGatewayMonitor;
import org.jetlinks.community.network.mqtt.client.MqttClient;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import reactor.core.publisher.Mono;

public class UnknownDeviceMqttClientSession
implements DeviceSession {
    private final String id;
    private final MqttClient client;
    private final DeviceGatewayMonitor monitor;
    private Duration keepAliveTimeout;

    public UnknownDeviceMqttClientSession(String id, MqttClient client, DeviceGatewayMonitor monitor) {
        this.id = id;
        this.client = client;
        this.monitor = monitor;
    }

    public String getDeviceId() {
        return null;
    }

    public DeviceOperator getOperator() {
        return null;
    }

    public long lastPingTime() {
        return 0L;
    }

    public long connectTime() {
        return 0L;
    }

    public void setKeepAliveTimeout(Duration keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        if (encodedMessage instanceof MqttMessage) {
            return this.client.publish((MqttMessage)encodedMessage).doOnSuccess(ignore -> this.monitor.sentMessage()).thenReturn((Object)true);
        }
        return Mono.error((Throwable)new UnsupportedOperationException("unsupported message type:" + encodedMessage.getClass()));
    }

    public Transport getTransport() {
        return DefaultTransport.MQTT;
    }

    public void close() {
    }

    public void ping() {
    }

    public boolean isAlive() {
        return this.client.isAlive();
    }

    public void onClose(Runnable call) {
    }

    public String getId() {
        return this.id;
    }
}

