/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.utils.ModuleUtils;
import org.jetlinks.community.logging.system.SerializableSystemLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class SystemLoggingAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final Logger log = LoggerFactory.getLogger(SystemLoggingAppender.class);
    public static ApplicationEventPublisher publisher;
    public static final Map<String, String> staticContext;

    protected void append(ILoggingEvent event) {
        IThrowableProxy proxy;
        if (publisher == null) {
            return;
        }
        StackTraceElement element = event.getCallerData()[0];
        IThrowableProxy proxies = event.getThrowableProxy();
        String message = event.getFormattedMessage();
        StringJoiner joiner = new StringJoiner("\n", message + "\n[", "]");
        LinkedList<IThrowableProxy> queue = new LinkedList<IThrowableProxy>();
        queue.add(proxies);
        while (queue.size() > 0 && (proxy = (IThrowableProxy)queue.poll()) != null) {
            int commonFrames = proxy.getCommonFrames();
            StackTraceElementProxy[] stepArray = proxy.getStackTraceElementProxyArray();
            StringBuilder stringBuilder = new StringBuilder();
            ThrowableProxyUtil.subjoinFirstLine((StringBuilder)stringBuilder, (IThrowableProxy)proxy);
            joiner.add(stringBuilder);
            for (int i = 0; i < stepArray.length - commonFrames; ++i) {
                StringBuilder sb = new StringBuilder();
                sb.append('\t');
                ThrowableProxyUtil.subjoinSTEP((StringBuilder)sb, (StackTraceElementProxy)stepArray[i]);
                joiner.add(sb);
            }
            queue.addAll(Arrays.asList(proxy.getSuppressed()));
        }
        String stack = joiner.toString();
        try {
            String gitLocation = null;
            String mavenModule = null;
            try {
                Class<?> clazz = Class.forName(element.getClassName());
                ModuleUtils.ModuleInfo moduleInfo = ModuleUtils.getModuleByClass(clazz);
                if (!StringUtils.isEmpty((Object)moduleInfo.getGitRepository())) {
                    StringBuilder javaSb = new StringBuilder();
                    javaSb.append(moduleInfo.getGitLocation());
                    javaSb.append("src/main/java/");
                    javaSb.append(ClassUtils.getPackageName(Class.forName(element.getClassName())).replace(".", "/"));
                    javaSb.append("/");
                    javaSb.append(Class.forName(element.getClassName()).getSimpleName());
                    javaSb.append(".java#L");
                    javaSb.append(element.getLineNumber());
                    gitLocation = javaSb.toString();
                }
                mavenModule = moduleInfo.getArtifactId();
            }
            catch (Exception clazz) {
                // empty catch block
            }
            HashMap<String, String> context = new HashMap<String, String>(staticContext);
            Map mdc = MDC.getCopyOfContextMap();
            if (mdc != null) {
                context.putAll(mdc);
            }
            SerializableSystemLog info = SerializableSystemLog.builder().id((String)IDGenerator.SNOW_FLAKE_STRING.generate()).mavenModule(mavenModule).context(context).name(event.getLoggerName()).level(event.getLevel().levelStr).className(element.getClassName()).methodName(element.getMethodName()).lineNumber(element.getLineNumber()).exceptionStack(stack).java(gitLocation).threadName(event.getThreadName()).createTime(event.getTimeStamp()).message(message).threadId(String.valueOf(Thread.currentThread().getId())).build();
            try {
                publisher.publishEvent((Object)info);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u7cfb\u7edf\u65e5\u5fd7\u9519\u8bef", (Throwable)e);
        }
    }

    static {
        staticContext = new ConcurrentHashMap<String, String>();
    }
}

