/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.logging.event.handler;

import org.jetlinks.community.elastic.search.index.DefaultElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.index.ElasticIndex;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexManager;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.service.ElasticSearchService;
import org.jetlinks.community.logging.event.handler.LoggerIndexProvider;
import org.jetlinks.community.logging.system.SerializableSystemLog;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
@Order(value=5)
public class SystemLoggerEventHandler {
    private static final Logger log = LoggerFactory.getLogger(SystemLoggerEventHandler.class);
    private final EventBus eventBus;
    private final ElasticSearchService elasticSearchService;

    public SystemLoggerEventHandler(ElasticSearchService elasticSearchService, ElasticSearchIndexManager indexManager, EventBus eventBus) {
        this.elasticSearchService = elasticSearchService;
        this.eventBus = eventBus;
        indexManager.putIndex((ElasticSearchIndexMetadata)new DefaultElasticSearchIndexMetadata(LoggerIndexProvider.SYSTEM.getIndex()).addProperty("createTime", (DataType)new DateTimeType()).addProperty("name", (DataType)new StringType()).addProperty("level", (DataType)new StringType()).addProperty("message", (DataType)new StringType()).addProperty("className", (DataType)new StringType()).addProperty("exceptionStack", (DataType)new StringType()).addProperty("methodName", (DataType)new StringType()).addProperty("threadId", (DataType)new StringType()).addProperty("threadName", (DataType)new StringType()).addProperty("id", (DataType)new StringType()).addProperty("context", (DataType)new ObjectType().addProperty("requestId", (DataType)new StringType()).addProperty("server", (DataType)new StringType()))).subscribe();
    }

    @EventListener
    public void acceptAccessLoggerInfo(SerializableSystemLog info) {
        this.eventBus.publish("/logging/system/" + info.getName().replace(".", "/") + "/" + info.getLevel().toLowerCase(), (Object)info).subscribe();
        this.elasticSearchService.commit((ElasticIndex)LoggerIndexProvider.SYSTEM, (Publisher)Mono.just((Object)info)).subscribe();
    }
}

