/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.monitor;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicReference;
import org.jetlinks.community.gateway.monitor.DeviceGatewayMonitor;

class MicrometerDeviceGatewayMonitor
implements DeviceGatewayMonitor {
    MeterRegistry registry;
    String id;
    String[] tags;
    private AtomicReference<Long> totalRef = new AtomicReference<Long>(0L);
    final Counter connected;
    final Counter rejected;
    final Counter disconnected;
    final Counter receivedMessage;
    final Counter sentMessage;

    public MicrometerDeviceGatewayMonitor(MeterRegistry registry, String id, String[] tags) {
        this.registry = registry;
        this.id = id;
        this.tags = tags;
        Gauge.builder((String)id, this.totalRef, AtomicReference::get).tags(tags).tag("target", "connection").register(registry);
        this.connected = this.getCounter("connected");
        this.rejected = this.getCounter("rejected");
        this.disconnected = this.getCounter("disconnected");
        this.sentMessage = this.getCounter("sent_message");
        this.receivedMessage = this.getCounter("received_message");
    }

    private Counter getCounter(String target) {
        return Counter.builder((String)this.id).tags(this.tags).tag("target", target).register(this.registry);
    }

    @Override
    public void totalConnection(long total) {
        this.totalRef.set(Math.max(0L, total));
    }

    @Override
    public void connected() {
        this.connected.increment();
    }

    @Override
    public void rejected() {
        this.rejected.increment();
    }

    @Override
    public void disconnected() {
        this.disconnected.increment();
    }

    @Override
    public void receivedMessage() {
        this.receivedMessage.increment();
    }

    @Override
    public void sentMessage() {
        this.sentMessage.increment();
    }
}

