/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.external;

import java.util.Map;
import org.hswebframework.web.authorization.Authentication;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.gateway.external.socket.MessagingRequest;

public class SubscribeRequest
implements ValueObject {
    private String id;
    private String topic;
    private Map<String, Object> parameter;
    private Authentication authentication;

    public Map<String, Object> values() {
        return this.parameter;
    }

    public static SubscribeRequest of(MessagingRequest request, Authentication authentication) {
        return SubscribeRequest.builder().id(request.getId()).topic(request.getTopic()).parameter(request.getParameter()).authentication(authentication).build();
    }

    public static SubscribeRequestBuilder builder() {
        return new SubscribeRequestBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTopic() {
        return this.topic;
    }

    public Map<String, Object> getParameter() {
        return this.parameter;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setParameter(Map<String, Object> parameter) {
        this.parameter = parameter;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public SubscribeRequest() {
    }

    public SubscribeRequest(String id, String topic, Map<String, Object> parameter, Authentication authentication) {
        this.id = id;
        this.topic = topic;
        this.parameter = parameter;
        this.authentication = authentication;
    }

    public static class SubscribeRequestBuilder {
        private String id;
        private String topic;
        private Map<String, Object> parameter;
        private Authentication authentication;

        SubscribeRequestBuilder() {
        }

        public SubscribeRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SubscribeRequestBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public SubscribeRequestBuilder parameter(Map<String, Object> parameter) {
            this.parameter = parameter;
            return this;
        }

        public SubscribeRequestBuilder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public SubscribeRequest build() {
            return new SubscribeRequest(this.id, this.topic, this.parameter, this.authentication);
        }

        public String toString() {
            return "SubscribeRequest.SubscribeRequestBuilder(id=" + this.id + ", topic=" + this.topic + ", parameter=" + this.parameter + ", authentication=" + this.authentication + ")";
        }
    }
}

