/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import org.jetlinks.community.gateway.DeviceGateway;
import org.jetlinks.community.gateway.GatewayState;
import org.jetlinks.community.gateway.monitor.DeviceGatewayMonitor;
import org.jetlinks.community.gateway.monitor.GatewayMonitors;
import org.jetlinks.core.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractDeviceGateway
implements DeviceGateway {
    private static final Logger log = LoggerFactory.getLogger(AbstractDeviceGateway.class);
    private static final AtomicReferenceFieldUpdater<AbstractDeviceGateway, GatewayState> STATE = AtomicReferenceFieldUpdater.newUpdater(AbstractDeviceGateway.class, GatewayState.class, "state");
    private final String id;
    private final List<BiConsumer<GatewayState, GatewayState>> stateListener = new CopyOnWriteArrayList<BiConsumer<GatewayState, GatewayState>>();
    private volatile GatewayState state = GatewayState.shutdown;
    protected final DeviceGatewayMonitor monitor;

    public AbstractDeviceGateway(String id) {
        this.id = id;
        this.monitor = GatewayMonitors.getDeviceGatewayMonitor(id, new String[0]);
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public Flux<Message> onMessage() {
        return Flux.empty();
    }

    @Override
    public final synchronized Mono<Void> startup() {
        if (this.state == GatewayState.paused) {
            this.changeState(GatewayState.started);
            return Mono.empty();
        }
        if (this.state == GatewayState.started || this.state == GatewayState.starting) {
            return Mono.empty();
        }
        this.changeState(GatewayState.starting);
        return this.doStartup().doOnSuccess(ignore -> this.changeState(GatewayState.started));
    }

    @Override
    public final Mono<Void> pause() {
        this.changeState(GatewayState.paused);
        return Mono.empty();
    }

    @Override
    public final Mono<Void> shutdown() {
        GatewayState old = STATE.getAndSet(this, GatewayState.shutdown);
        if (old == GatewayState.shutdown) {
            return Mono.empty();
        }
        this.changeState(GatewayState.shutdown);
        return this.doShutdown();
    }

    protected abstract Mono<Void> doShutdown();

    protected abstract Mono<Void> doStartup();

    protected final synchronized void changeState(GatewayState target) {
        GatewayState old = STATE.getAndSet(this, target);
        if (target == old) {
            return;
        }
        for (BiConsumer<GatewayState, GatewayState> consumer : this.stateListener) {
            try {
                consumer.accept(old, this.state);
            }
            catch (Throwable error) {
                log.warn("fire gateway {} state listener error", (Object)this.getId(), (Object)error);
            }
        }
    }

    @Override
    public final GatewayState getState() {
        return this.state;
    }

    @Override
    public final void doOnStateChange(BiConsumer<GatewayState, GatewayState> listener) {
        this.stateListener.add(listener);
    }

    @Override
    public final void doOnShutdown(Disposable disposable) {
        DeviceGateway.super.doOnShutdown(disposable);
    }

    @Override
    public final boolean isAlive() {
        return this.state == GatewayState.started || this.state == GatewayState.starting;
    }
}

