/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.timeseries;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.elastic.search.index.DefaultElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexManager;
import org.jetlinks.community.elastic.search.service.AggregationService;
import org.jetlinks.community.elastic.search.service.ElasticSearchService;
import org.jetlinks.community.elastic.search.timeseries.ElasticSearchTimeSeriesService;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.community.timeseries.TimeSeriesMetadata;
import org.jetlinks.community.timeseries.TimeSeriesMetric;
import org.jetlinks.community.timeseries.TimeSeriesService;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ElasticSearchTimeSeriesManager
implements TimeSeriesManager {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchTimeSeriesManager.class);
    private final Map<String, TimeSeriesService> serviceMap = new ConcurrentHashMap<String, TimeSeriesService>(16);
    protected final ElasticSearchIndexManager indexManager;
    private final ElasticSearchService elasticSearchService;
    private final AggregationService aggregationService;

    public ElasticSearchTimeSeriesManager(ElasticSearchIndexManager indexManager, ElasticSearchService elasticSearchService, AggregationService aggregationService) {
        this.elasticSearchService = elasticSearchService;
        this.indexManager = indexManager;
        this.aggregationService = aggregationService;
    }

    public TimeSeriesService getService(TimeSeriesMetric metric) {
        return this.getService(metric.getId());
    }

    public TimeSeriesService getServices(TimeSeriesMetric ... metric) {
        return this.getServices((String[])Arrays.stream(metric).map(TimeSeriesMetric::getId).toArray(String[]::new));
    }

    public TimeSeriesService getServices(String ... metric) {
        return new ElasticSearchTimeSeriesService(metric, this.elasticSearchService, this.aggregationService);
    }

    public TimeSeriesService getService(String metric) {
        return this.serviceMap.computeIfAbsent(metric, id -> new ElasticSearchTimeSeriesService(new String[]{id}, this.elasticSearchService, this.aggregationService));
    }

    public Mono<Void> registerMetadata(TimeSeriesMetadata metadata) {
        SimplePropertyMetadata timestamp = new SimplePropertyMetadata();
        timestamp.setId("timestamp");
        timestamp.setValueType((DataType)new DateTimeType());
        return this.indexManager.putIndex(new DefaultElasticSearchIndexMetadata(metadata.getMetric().getId(), metadata.getProperties()).addProperty((PropertyMetadata)timestamp));
    }
}

