/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.service;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.elastic.search.index.ElasticIndex;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ElasticSearchService {
    default public <T> Mono<PagerResult<T>> queryPager(String index, QueryParam queryParam, Function<Map<String, Object>, T> mapper) {
        return this.queryPager(new String[]{index}, queryParam, mapper);
    }

    public <T> Mono<PagerResult<T>> queryPager(String[] var1, QueryParam var2, Function<Map<String, Object>, T> var3);

    public <T> Flux<T> query(String var1, QueryParam var2, Function<Map<String, Object>, T> var3);

    public <T> Flux<T> query(String[] var1, QueryParam var2, Function<Map<String, Object>, T> var3);

    default public <T> Flux<T> multiQuery(String index, Collection<QueryParam> queryParam, Function<Map<String, Object>, T> mapper) {
        return this.multiQuery(new String[]{index}, queryParam, mapper);
    }

    public <T> Flux<T> multiQuery(String[] var1, Collection<QueryParam> var2, Function<Map<String, Object>, T> var3);

    default public Mono<Long> count(String index, QueryParam queryParam) {
        return this.count(new String[]{index}, queryParam);
    }

    public Mono<Long> count(String[] var1, QueryParam var2);

    public Mono<Long> delete(String var1, QueryParam var2);

    public <T> Mono<Void> commit(String var1, T var2);

    public <T> Mono<Void> commit(String var1, Collection<T> var2);

    public <T> Mono<Void> commit(String var1, Publisher<T> var2);

    public <T> Mono<Void> save(String var1, T var2);

    public <T> Mono<Void> save(String var1, Collection<T> var2);

    public <T> Mono<Void> save(String var1, Publisher<T> var2);

    default public <T> Flux<T> query(String index, QueryParam queryParam, Class<T> type) {
        return this.query(index, queryParam, (Map<String, Object> map) -> FastBeanCopier.copy((Object)map, (Class)type, (String[])new String[0]));
    }

    default public <T> Mono<PagerResult<T>> queryPager(String index, QueryParam queryParam, Class<T> type) {
        return this.queryPager(index, queryParam, (Map<String, Object> map) -> FastBeanCopier.copy((Object)map, (Class)type, (String[])new String[0]));
    }

    default public <T> Mono<PagerResult<T>> queryPager(ElasticIndex index, QueryParam queryParam, Class<T> type) {
        return this.queryPager(index.getIndex(), queryParam, (Map<String, Object> map) -> FastBeanCopier.copy((Object)map, (Class)type, (String[])new String[0]));
    }

    default public <T> Mono<PagerResult<T>> queryPager(ElasticIndex index, QueryParam queryParam, Function<Map<String, Object>, T> mapper) {
        return this.queryPager(index.getIndex(), queryParam, mapper);
    }

    default public <T> Flux<T> query(ElasticIndex index, QueryParam queryParam, Class<T> type) {
        return this.query(index.getIndex(), queryParam, (Map<String, Object> map) -> FastBeanCopier.copy((Object)map, (Class)type, (String[])new String[0]));
    }

    default public <T> Flux<T> query(ElasticIndex index, QueryParam queryParam, Function<Map<String, Object>, T> mapper) {
        return this.query(index.getIndex(), queryParam, mapper);
    }

    default public <T> Mono<Long> count(ElasticIndex index, QueryParam data) {
        return this.count(index.getIndex(), data);
    }

    default public <T> Mono<Void> commit(ElasticIndex index, T data) {
        return this.commit(index.getIndex(), data);
    }

    default public <T> Mono<Void> commit(ElasticIndex index, Collection<T> data) {
        return this.commit(index.getIndex(), data);
    }

    default public <T> Mono<Void> commit(ElasticIndex index, Publisher<T> data) {
        return this.commit(index.getIndex(), data);
    }
}

