/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.enums;

import java.util.function.Supplier;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.exception.NotFoundException;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.DoubleType;
import org.jetlinks.core.metadata.types.FileType;
import org.jetlinks.core.metadata.types.FloatType;
import org.jetlinks.core.metadata.types.GeoType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.LongType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.springframework.util.StringUtils;

public enum ElasticPropertyType implements EnumDict<String>
{
    TEXT("text", "text", StringType::new),
    BYTE("byte", "byte", () -> new IntType().min((Number)-128).max((Number)127)),
    SHORT("short", "short", () -> new IntType().min((Number)Short.MIN_VALUE).max((Number)Short.MAX_VALUE)),
    INTEGER("int", "integer", IntType::new),
    LONG("long", "long", LongType::new),
    DATE("date", "date", DateTimeType::new),
    HALF_FLOAT("half_float", "half_float", FloatType::new),
    FLOAT("float", "float", FloatType::new),
    DOUBLE("double", "double", DoubleType::new),
    BOOLEAN("boolean", "boolean", BooleanType::new),
    OBJECT("object", "object", ObjectType::new),
    AUTO("auto", "auto", () -> null),
    NESTED("nested", "nested", ObjectType::new),
    IP("ip", "ip", LongType::new),
    ATTACHMENT("attachment", "attachment", FileType::new),
    KEYWORD("string", "keyword", StringType::new),
    GEO_POINT("geo_point", "geo_point", GeoType::new);

    private String text;
    private String value;
    private Supplier<DataType> typeBuilder;

    public DataType getType() {
        return this.typeBuilder.get();
    }

    public static ElasticPropertyType of(Object value) {
        if (!StringUtils.isEmpty((Object)value)) {
            for (ElasticPropertyType elasticPropertyType : ElasticPropertyType.values()) {
                if (!elasticPropertyType.getValue().equals(value)) continue;
                return elasticPropertyType;
            }
        }
        return null;
    }

    public static ElasticPropertyType ofJava(Object value) {
        if (!StringUtils.isEmpty((Object)value)) {
            for (ElasticPropertyType elasticPropertyType : ElasticPropertyType.values()) {
                if (!elasticPropertyType.getText().equals(value)) continue;
                return elasticPropertyType;
            }
        }
        throw new NotFoundException("\u672a\u627e\u5230\u6570\u636e\u7c7b\u578b\u4e3a\uff1a" + value + "\u7684\u679a\u4e3e", new Object[0]);
    }

    private ElasticPropertyType(String text, String value, Supplier<DataType> typeBuilder) {
        this.text = text;
        this.value = value;
        this.typeBuilder = typeBuilder;
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }
}

