/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.aggreation.enums;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.jetlinks.community.elastic.search.aggreation.bucket.AggregationResponseHandle;
import org.jetlinks.community.elastic.search.aggreation.bucket.Bucket;
import org.jetlinks.community.elastic.search.aggreation.bucket.BucketAggregationsStructure;
import org.jetlinks.community.elastic.search.aggreation.bucket.Sort;
import org.jetlinks.community.elastic.search.aggreation.enums.OrderType;
import org.jetlinks.community.elastic.search.aggreation.metrics.MetricsAggregationStructure;
import org.springframework.util.StringUtils;

public enum BucketType {
    TERMS("\u5b57\u6bb5\u9879"){

        @Override
        public AggregationBuilder aggregationBuilder(BucketAggregationsStructure structure) {
            Sort sort;
            TermsAggregationBuilder builder = (TermsAggregationBuilder)AggregationBuilders.terms((String)structure.getName()).field(structure.getField());
            if (structure.getSize() != null) {
                builder.size(structure.getSize().intValue());
            }
            if ((sort = structure.getSort()) != null) {
                builder.order((BucketOrder)mapping.get(OrderBuilder.of(sort.getOrder(), sort.getType())));
            }
            if (structure.getMissingValue() != null) {
                builder.missing(structure.getMissingValue());
            }
            BucketType.commonAggregationSetting((AggregationBuilder)builder, structure);
            return builder;
        }

        @Override
        public <A extends Aggregation> List<Bucket> convert(A a) {
            return AggregationResponseHandle.terms(a);
        }
    }
    ,
    RANGE("\u8303\u56f4"){

        @Override
        public AggregationBuilder aggregationBuilder(BucketAggregationsStructure structure) {
            RangeAggregationBuilder builder = (RangeAggregationBuilder)AggregationBuilders.range((String)structure.getName()).field(structure.getField());
            if (StringUtils.hasText((String)structure.getFormat())) {
                String format = structure.getFormat();
                if (format.startsWith("yyyy")) {
                    format = "8" + format;
                }
                builder.format(format);
            }
            structure.getRanges().forEach(ranges -> builder.addRange(ranges.getKey(), ((Double)ranges.getForm()).doubleValue(), ((Double)ranges.getTo()).doubleValue()));
            BucketType.commonAggregationSetting((AggregationBuilder)builder, structure);
            return builder;
        }

        @Override
        public <A extends Aggregation> List<Bucket> convert(A a) {
            return AggregationResponseHandle.range(a);
        }
    }
    ,
    DATE_RANGE("\u65f6\u95f4\u8303\u56f4"){

        @Override
        public AggregationBuilder aggregationBuilder(BucketAggregationsStructure structure) {
            DateRangeAggregationBuilder builder = (DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)structure.getName()).field(structure.getField());
            if (StringUtils.hasText((String)structure.getFormat())) {
                String format = structure.getFormat();
                if (format.startsWith("yyyy")) {
                    format = "8" + format;
                }
                builder.format(format);
            }
            structure.getRanges().forEach(ranges -> builder.addRange(ranges.getKey(), ranges.getForm().toString(), ranges.getTo().toString()));
            if (structure.getMissingValue() != null) {
                builder.missing(structure.getMissingValue());
            }
            builder.timeZone(ZoneId.systemDefault());
            BucketType.commonAggregationSetting((AggregationBuilder)builder, structure);
            return builder;
        }

        @Override
        public <A extends Aggregation> List<Bucket> convert(A a) {
            return AggregationResponseHandle.range(a);
        }
    }
    ,
    DATE_HISTOGRAM("\u65f6\u95f4\u8303\u56f4"){

        @Override
        public AggregationBuilder aggregationBuilder(BucketAggregationsStructure structure) {
            Sort sort;
            DateHistogramAggregationBuilder builder = (DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)structure.getName()).field(structure.getField());
            if (StringUtils.hasText((String)structure.getFormat())) {
                builder.format(structure.getFormat());
            }
            if (StringUtils.hasText((String)structure.getInterval())) {
                builder.dateHistogramInterval(new DateHistogramInterval(structure.getInterval()));
            }
            if (structure.getExtendedBounds() != null) {
                builder.extendedBounds(structure.getExtendedBounds());
            }
            if (structure.getMissingValue() != null) {
                builder.missing(structure.getMissingValue());
            }
            if ((sort = structure.getSort()) != null) {
                builder.order((BucketOrder)mapping.get(OrderBuilder.of(sort.getOrder(), sort.getType())));
            }
            builder.timeZone(ZoneId.systemDefault());
            BucketType.commonAggregationSetting((AggregationBuilder)builder, structure);
            return builder;
        }

        @Override
        public <A extends Aggregation> List<Bucket> convert(A a) {
            return AggregationResponseHandle.dateHistogram(a);
        }
    };

    private final String text;
    static Map<OrderBuilder, BucketOrder> mapping;

    public abstract AggregationBuilder aggregationBuilder(BucketAggregationsStructure var1);

    public abstract <A extends Aggregation> List<Bucket> convert(A var1);

    private static void commonAggregationSetting(AggregationBuilder builder, BucketAggregationsStructure structure) {
        if (structure.getSubMetricsAggregation() != null && structure.getSubMetricsAggregation().size() > 0) {
            BucketType.addMetricsSubAggregation(builder, structure.getSubMetricsAggregation());
        }
        if (structure.getSubBucketAggregation() != null && structure.getSubBucketAggregation().size() > 0) {
            BucketType.addBucketSubAggregation(builder, structure.getSubBucketAggregation());
        }
    }

    private static void addMetricsSubAggregation(AggregationBuilder builder, List<MetricsAggregationStructure> subMetricsAggregation) {
        subMetricsAggregation.forEach(subStructure -> builder.subAggregation(subStructure.getType().aggregationBuilder(subStructure.getName(), subStructure.getField())));
    }

    private static void addBucketSubAggregation(AggregationBuilder builder, List<BucketAggregationsStructure> subBucketAggregation) {
        subBucketAggregation.forEach(subStructure -> builder.subAggregation(subStructure.getType().aggregationBuilder((BucketAggregationsStructure)subStructure)));
    }

    public String getText() {
        return this.text;
    }

    private BucketType(String text) {
        this.text = text;
    }

    static {
        mapping = new HashMap<OrderBuilder, BucketOrder>();
        mapping.put(OrderBuilder.of("asc", OrderType.COUNT), BucketOrder.count((boolean)true));
        mapping.put(OrderBuilder.of("desc", OrderType.COUNT), BucketOrder.count((boolean)false));
        mapping.put(OrderBuilder.of("asc", OrderType.KEY), BucketOrder.key((boolean)true));
        mapping.put(OrderBuilder.of("desc", OrderType.KEY), BucketOrder.key((boolean)false));
    }

    static class OrderBuilder {
        private String order;
        private OrderType orderType;

        public String getOrder() {
            return this.order;
        }

        public OrderType getOrderType() {
            return this.orderType;
        }

        private OrderBuilder(String order, OrderType orderType) {
            this.order = order;
            this.orderType = orderType;
        }

        public static OrderBuilder of(String order, OrderType orderType) {
            return new OrderBuilder(order, orderType);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderBuilder)) {
                return false;
            }
            OrderBuilder other = (OrderBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$order = this.getOrder();
            String other$order = other.getOrder();
            if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
                return false;
            }
            OrderType this$orderType = this.getOrderType();
            OrderType other$orderType = other.getOrderType();
            return !(this$orderType == null ? other$orderType != null : !((Object)((Object)this$orderType)).equals((Object)other$orderType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrderBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : $order.hashCode());
            OrderType $orderType = this.getOrderType();
            result = result * 59 + ($orderType == null ? 43 : ((Object)((Object)$orderType)).hashCode());
            return result;
        }
    }
}

