/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.elasticsearch.common.logging.PrefixLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public class Loggers {
    public static final String SPACE = " ";
    public static final Setting<Level> LOG_DEFAULT_LEVEL_SETTING = new Setting("logger.level", Level.INFO.name(), Level::valueOf, new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting.AffixSetting<Level> LOG_LEVEL_SETTING = Setting.prefixKeySetting((String)"logger.", key -> new Setting(key, Level.INFO.name(), Level::valueOf, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}));

    public static Logger getLogger(Class<?> clazz, ShardId shardId, String ... prefixes) {
        return Loggers.getLogger(clazz, shardId.getIndex(), CollectionUtils.asArrayList((Object)Integer.toString(shardId.id()), (Object[])prefixes).toArray(new String[0]));
    }

    public static Logger getLogger(String loggerName, ShardId shardId) {
        String prefix = Loggers.formatPrefix(shardId.getIndexName(), Integer.toString(shardId.id()));
        return new PrefixLogger(LogManager.getLogger((String)loggerName), prefix);
    }

    public static Logger getLogger(Class<?> clazz, Index index, String ... prefixes) {
        return Loggers.getLogger(clazz, CollectionUtils.asArrayList((Object)SPACE, (Object)index.getName(), (Object[])prefixes).toArray(new String[0]));
    }

    public static Logger getLogger(Class<?> clazz, String ... prefixes) {
        return new PrefixLogger(LogManager.getLogger(clazz), Loggers.formatPrefix(prefixes));
    }

    public static Logger getLogger(Logger parentLogger, String s) {
        Logger inner = LogManager.getLogger((String)(parentLogger.getName() + s));
        if (parentLogger instanceof PrefixLogger) {
            return new PrefixLogger(inner, ((PrefixLogger)parentLogger).prefix());
        }
        return inner;
    }

    private static String formatPrefix(String ... prefixes) {
        String prefix = null;
        if (prefixes != null && prefixes.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String prefixX : prefixes) {
                if (prefixX == null) continue;
                if (prefixX.equals(SPACE)) {
                    sb.append(SPACE);
                    continue;
                }
                sb.append("[").append(prefixX).append("]");
            }
            if (sb.length() > 0) {
                prefix = sb.toString();
            }
        }
        return prefix;
    }

    public static void setLevel(Logger logger, String level) {
        Level l = level == null ? null : Level.valueOf((String)level);
        Loggers.setLevel(logger, l);
    }

    public static void setLevel(Logger logger, Level level) {
    }

    public static void addAppender(Logger logger, Appender appender) {
    }

    public static void removeAppender(Logger logger, Appender appender) {
    }

    public static Appender findAppender(Logger logger, Class<? extends Appender> clazz) {
        return null;
    }
}

