/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.service.reactive;

import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ValueCount;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.Interval;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexManager;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexStrategy;
import org.jetlinks.community.elastic.search.service.AggregationService;
import org.jetlinks.community.elastic.search.service.reactive.AggType;
import org.jetlinks.community.elastic.search.service.reactive.ReactiveElasticSearchService;
import org.jetlinks.community.elastic.search.service.reactive.ReactiveElasticsearchClient;
import org.jetlinks.community.elastic.search.utils.ElasticSearchConverter;
import org.jetlinks.community.timeseries.query.AggregationColumn;
import org.jetlinks.community.timeseries.query.AggregationQueryParam;
import org.jetlinks.community.timeseries.query.Group;
import org.jetlinks.community.timeseries.query.LimitAggregationColumn;
import org.jetlinks.community.timeseries.query.LimitGroup;
import org.jetlinks.community.timeseries.query.TimeGroup;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAggregationService
implements AggregationService {
    private static final Logger log = LoggerFactory.getLogger(ReactiveAggregationService.class);
    private final ReactiveElasticsearchClient restClient;
    private final ElasticSearchIndexManager indexManager;
    static long thirtyDayMillis = Duration.ofDays(Integer.getInteger("elasticsearch.agg.default-range-day", 90).intValue()).toMillis();

    @Autowired
    public ReactiveAggregationService(ElasticSearchIndexManager indexManager, ReactiveElasticsearchClient restClient) {
        this.restClient = restClient;
        this.indexManager = indexManager;
    }

    private Mono<SearchSourceBuilder> createSearchSourceBuilder(QueryParam queryParam, String index) {
        return this.indexManager.getIndexMetadata(index).map(metadata -> ElasticSearchConverter.convertSearchSourceBuilder(queryParam, metadata));
    }

    private AggregationBuilder createBuilder(Group group, AggregationQueryParam param) {
        if (group instanceof TimeGroup) {
            TimeGroup timeGroup = (TimeGroup)group;
            DateHistogramAggregationBuilder builder = (DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)timeGroup.getAlias()).field(timeGroup.getProperty());
            if (StringUtils.hasText((String)timeGroup.getFormat())) {
                String format = timeGroup.getFormat();
                if (format.startsWith("yyyy")) {
                    format = "8" + format;
                }
                builder.format(format);
            }
            builder.timeZone(ZoneId.systemDefault());
            builder.order(BucketOrder.key((boolean)false));
            if (timeGroup.getInterval() != null) {
                Interval interval = timeGroup.getInterval();
                String intervalString = interval.toString();
                if (this.restClient.serverVersion().after(Version.V_7_2_0)) {
                    if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.containsKey(intervalString)) {
                        builder.calendarInterval(new DateHistogramInterval(intervalString));
                    } else {
                        builder.fixedInterval(new DateHistogramInterval(intervalString));
                    }
                } else {
                    builder.dateHistogramInterval(new DateHistogramInterval(intervalString));
                }
            }
            builder.extendedBounds(ReactiveAggregationService.getExtendedBounds(param));
            return builder;
        }
        TermsAggregationBuilder builder = (TermsAggregationBuilder)AggregationBuilders.terms((String)group.getAlias()).field(group.getProperty());
        if (group instanceof LimitGroup) {
            if (((LimitGroup)group).getLimit() > 0) {
                builder.size(((LimitGroup)group).getLimit());
            }
        } else {
            builder.size(100);
        }
        return builder.executionHint("map");
    }

    @Override
    public Flux<Map<String, Object>> aggregation(String[] index, AggregationQueryParam aggregationQueryParam) {
        QueryParam queryParam = ReactiveAggregationService.prepareQueryParam(aggregationQueryParam);
        ArrayList<TimeGroup> groups = new ArrayList<TimeGroup>();
        if (aggregationQueryParam.getGroupByTime() != null) {
            groups.add(aggregationQueryParam.getGroupByTime());
        }
        groups.addAll(aggregationQueryParam.getGroupBy());
        ArrayList<AggregationBuilder> aggs = new ArrayList<AggregationBuilder>();
        AggregationBuilder aggregationBuilder = null;
        AggregationBuilder lastAgg = null;
        if (!groups.isEmpty()) {
            Group first = (Group)groups.get(0);
            aggregationBuilder = lastAgg = this.createBuilder(first, aggregationQueryParam);
            for (int i = 1; i < groups.size(); ++i) {
                lastAgg = this.createBuilder((Group)groups.get(i), aggregationQueryParam);
                aggregationBuilder.subAggregation(lastAgg);
            }
            aggs.add(aggregationBuilder);
        }
        boolean group = aggregationBuilder != null;
        for (AggregationColumn aggColumn : aggregationQueryParam.getAggColumns()) {
            AggregationBuilder builder = AggType.of(aggColumn.getAggregation().name()).aggregationBuilder(aggColumn.getAlias(), aggColumn.getProperty());
            if (builder instanceof TopHitsAggregationBuilder) {
                TopHitsAggregationBuilder topHitsBuilder = (TopHitsAggregationBuilder)builder;
                if (CollectionUtils.isEmpty((Collection)queryParam.getSorts())) {
                    topHitsBuilder.sort(aggregationQueryParam.getTimeProperty(), SortOrder.DESC);
                } else {
                    topHitsBuilder.sorts(queryParam.getSorts().stream().map(sort -> (FieldSortBuilder)SortBuilders.fieldSort((String)sort.getName()).order("desc".equalsIgnoreCase(sort.getOrder()) ? SortOrder.DESC : SortOrder.ASC)).collect(Collectors.toList()));
                }
                if (aggColumn instanceof LimitAggregationColumn) {
                    topHitsBuilder.size(((LimitAggregationColumn)aggColumn).getLimit());
                } else {
                    topHitsBuilder.size(1);
                }
            }
            if (group) {
                lastAgg.subAggregation(builder);
                continue;
            }
            aggs.add(builder);
        }
        return (Flux)Flux.fromArray((Object[])index).flatMap(idx -> Mono.zip(this.indexManager.getIndexStrategy((String)idx), (Mono)Mono.just((Object)idx))).collectList().flatMap(strategy -> this.createSearchSourceBuilder(queryParam, index[0]).map(builder -> {
            aggs.forEach(arg_0 -> ((SearchSourceBuilder)builder.size(0)).aggregation(arg_0));
            return new SearchRequest((String[])strategy.stream().map(tp2 -> ((ElasticSearchIndexStrategy)tp2.getT1()).getIndexForSearch((String)tp2.getT2())).toArray(String[]::new)).indicesOptions(ReactiveElasticSearchService.indexOptions).source(builder);
        })).flatMap(this.restClient::searchForPage).flatMapMany(this::parseResult).as(flux -> {
            if (!group) {
                return flux.map(Map::entrySet).flatMap(Flux::fromIterable).collectMap(Map.Entry::getKey, Map.Entry::getValue).flux();
            }
            return flux;
        });
    }

    protected Flux<Map<String, Object>> parseResult(SearchResponse searchResponse) {
        return Mono.justOrEmpty((Object)searchResponse.getAggregations()).flatMapIterable(Aggregations::asList).flatMap(agg -> this.parseAggregation(agg.getName(), (Aggregation)agg), Integer.MAX_VALUE);
    }

    private Flux<Map<String, Object>> parseAggregation(String name, Aggregation aggregation) {
        if (aggregation instanceof Terms) {
            return this.parseAggregation((Terms)aggregation);
        }
        if (aggregation instanceof TopHits) {
            TopHits topHits = (TopHits)aggregation;
            return Flux.fromArray((Object[])topHits.getHits().getHits()).map(hit -> {
                Map val = hit.getSourceAsMap();
                if (!val.containsKey("id")) {
                    val.put("id", hit.getId());
                }
                return val;
            });
        }
        if (aggregation instanceof Histogram) {
            return this.parseAggregation((Histogram)aggregation);
        }
        if (aggregation instanceof ValueCount) {
            return Flux.just(Collections.singletonMap(name, ((ValueCount)aggregation).getValue()));
        }
        if (aggregation instanceof NumericMetricsAggregation.SingleValue) {
            return Flux.just(Collections.singletonMap(name, this.getSafeNumber(((NumericMetricsAggregation.SingleValue)aggregation).value())));
        }
        if (aggregation instanceof ExtendedStats) {
            ExtendedStats stats = (ExtendedStats)aggregation;
            return Flux.just(Collections.singletonMap(name, stats.getStdDeviation()));
        }
        return Flux.empty();
    }

    private double getSafeNumber(double number) {
        return Double.isNaN(number) || Double.isInfinite(number) ? 0.0 : number;
    }

    private Flux<Map<String, Object>> parseAggregation(Histogram aggregation) {
        return Flux.fromIterable((Iterable)aggregation.getBuckets()).flatMap(bucket -> Flux.fromIterable((Iterable)bucket.getAggregations().asList()).flatMap(agg -> this.parseAggregation(agg.getName(), (Aggregation)agg), Integer.MAX_VALUE).defaultIfEmpty(Collections.emptyMap()).map(map -> {
            HashMap<String, Object> val = new HashMap<String, Object>((Map<String, Object>)map);
            val.put(aggregation.getName(), bucket.getKeyAsString());
            val.put("_" + aggregation.getName(), bucket.getKey());
            return val;
        }), Integer.MAX_VALUE);
    }

    private Flux<Map<String, Object>> parseAggregation(Terms aggregation) {
        return Flux.fromIterable((Iterable)aggregation.getBuckets()).flatMap(bucket -> Flux.fromIterable((Iterable)bucket.getAggregations().asList()).flatMap(agg -> this.parseAggregation(agg.getName(), (Aggregation)agg).map(map -> {
            HashMap<String, String> val = new HashMap<String, String>((Map<String, String>)map);
            val.put(aggregation.getName(), bucket.getKeyAsString());
            return val;
        })));
    }

    protected static QueryParam prepareQueryParam(AggregationQueryParam param) {
        QueryParamEntity queryParam = param.getQueryParam().clone();
        queryParam.setPaging(false);
        boolean hasTimestamp = false;
        for (Term term : queryParam.getTerms()) {
            if (!param.getTimeProperty().equals(term.getColumn())) continue;
            hasTimestamp = true;
        }
        if (!hasTimestamp) {
            queryParam.and(param.getTimeProperty(), "btw", Arrays.asList(ReactiveAggregationService.calculateStartWithTime(param), param.getEndWithTime()));
        }
        if (queryParam.getSorts().isEmpty()) {
            queryParam.orderBy(param.getTimeProperty()).desc();
        }
        return queryParam;
    }

    protected static LongBounds getExtendedBounds(AggregationQueryParam param) {
        return new LongBounds(Long.valueOf(ReactiveAggregationService.calculateStartWithTime(param)), Long.valueOf(param.getEndWithTime()));
    }

    static long calculateStartWithTime(AggregationQueryParam param) {
        long startWithParam = param.getStartWithTime();
        if (startWithParam == 0L) {
            List terms = param.getQueryParam().getTerms();
            for (Term term : terms) {
                if (!"timestamp".equals(term.getColumn())) continue;
                List<String> value = term.getValue();
                String termType = term.getTermType();
                if ("btw".equals(termType)) {
                    if (String.valueOf(value).contains(",")) {
                        value = Arrays.asList(String.valueOf(value).split(","));
                    }
                    return DateTimeType.GLOBAL.convert(CastUtils.castArray((Object)value).get(0)).getTime();
                }
                if (!"gt".equals(termType) && !"gte".equals(termType)) continue;
                return DateTimeType.GLOBAL.convert((Object)value).getTime();
            }
            return param.getEndWithTime() - thirtyDayMillis;
        }
        return startWithParam;
    }
}

