/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.hswebframework.ezorm.core.param.Term;
import org.jetlinks.community.elastic.search.utils.TermCommonUtils;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.springframework.util.StringUtils;

public enum TermTypeEnum {
    eq("eq"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.termQuery((String)term.getColumn().trim(), (Object)term.getValue());
        }
    }
    ,
    not("not"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)term.getColumn().trim(), (Object)term.getValue()));
        }
    }
    ,
    btw("btw"){

        @Override
        public QueryBuilder process(Term term) {
            Number between = null;
            Number and = null;
            List<Object> values = TermCommonUtils.convertToList(term.getValue());
            if (values.size() > 0) {
                between = CastUtils.castNumber((Object)values.get(0));
            }
            if (values.size() > 1) {
                and = CastUtils.castNumber((Object)values.get(1));
            }
            return QueryBuilders.rangeQuery((String)term.getColumn().trim()).gte((Object)between).lte((Object)and);
        }
    }
    ,
    gt("gt"){

        @Override
        public QueryBuilder process(Term term) {
            Number value = CastUtils.castNumber((Object)term.getValue());
            return QueryBuilders.rangeQuery((String)term.getColumn().trim()).gt((Object)value);
        }
    }
    ,
    gte("gte"){

        @Override
        public QueryBuilder process(Term term) {
            Number value = CastUtils.castNumber((Object)term.getValue());
            return QueryBuilders.rangeQuery((String)term.getColumn().trim()).gte((Object)value);
        }
    }
    ,
    lt("lt"){

        @Override
        public QueryBuilder process(Term term) {
            Number value = CastUtils.castNumber((Object)term.getValue());
            return QueryBuilders.rangeQuery((String)term.getColumn().trim()).lt((Object)value);
        }
    }
    ,
    lte("lte"){

        @Override
        public QueryBuilder process(Term term) {
            Number value = CastUtils.castNumber((Object)term.getValue());
            return QueryBuilders.rangeQuery((String)term.getColumn().trim()).lte((Object)value);
        }
    }
    ,
    in("in"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.termsQuery((String)term.getColumn().trim(), TermCommonUtils.convertToList(term.getValue()));
        }
    }
    ,
    like("like"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.wildcardQuery((String)term.getColumn().trim(), (String)9.likeQueryTermValueHandler(term.getValue()));
        }
    }
    ,
    nlike("nlike"){

        @Override
        public QueryBuilder process(Term term) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)term.getColumn().trim(), (String)10.likeQueryTermValueHandler(term.getValue())));
        }
    };

    private final String type;

    public abstract QueryBuilder process(Term var1);

    public static String likeQueryTermValueHandler(Object value) {
        if (!StringUtils.isEmpty((Object)value)) {
            return value.toString().replace("%", "*");
        }
        return "**";
    }

    public static Optional<TermTypeEnum> of(String type) {
        return Arrays.stream(TermTypeEnum.values()).filter(e -> e.getType().equalsIgnoreCase(type)).findAny();
    }

    public String getType() {
        return this.type;
    }

    private TermTypeEnum(String type) {
        this.type = type;
    }
}

