/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web.response;

import java.util.List;
import java.util.stream.Collectors;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.enums.DeviceState;
import org.jetlinks.community.device.web.response.ChildrenDeviceInfo;

public class GatewayDeviceInfo {
    private String id;
    private String name;
    private String description;
    private DeviceState state;
    private List<ChildrenDeviceInfo> children;

    public static GatewayDeviceInfo of(DeviceInstanceEntity gateway, List<DeviceInstanceEntity> children) {
        GatewayDeviceInfo info = new GatewayDeviceInfo();
        info.setId(gateway.getId());
        info.setName(gateway.getName());
        info.setDescription(gateway.getDescribe());
        info.setState(gateway.getState());
        info.setChildren(children.stream().map(ChildrenDeviceInfo::of).collect(Collectors.toList()));
        return info;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DeviceState getState() {
        return this.state;
    }

    public List<ChildrenDeviceInfo> getChildren() {
        return this.children;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setState(DeviceState state) {
        this.state = state;
    }

    public void setChildren(List<ChildrenDeviceInfo> children) {
        this.children = children;
    }
}

