/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web;

import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBufAllocator;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.community.device.entity.ProtocolSupportEntity;
import org.jetlinks.community.device.service.LocalProtocolSupportService;
import org.jetlinks.community.device.web.protocol.ProtocolDetail;
import org.jetlinks.community.device.web.protocol.ProtocolInfo;
import org.jetlinks.community.device.web.protocol.TransportInfo;
import org.jetlinks.community.device.web.request.ProtocolDecodeRequest;
import org.jetlinks.community.device.web.request.ProtocolEncodeRequest;
import org.jetlinks.community.io.file.FileManager;
import org.jetlinks.community.io.file.FileOption;
import org.jetlinks.community.protocol.TransportDetail;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.unit.ValueUnit;
import org.jetlinks.core.metadata.unit.ValueUnits;
import org.jetlinks.supports.protocol.management.ProtocolSupportDefinition;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoader;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoaderProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@RestController
@RequestMapping(value={"/protocol"})
@Authorize
@Resource(id="protocol-supports", name="\u534f\u8bae\u7ba1\u7406")
@Tag(name="\u534f\u8bae\u7ba1\u7406")
public class ProtocolSupportController
implements ReactiveServiceCrudController<ProtocolSupportEntity, String> {
    @Autowired
    private LocalProtocolSupportService service;
    @Autowired
    private ProtocolSupports protocolSupports;
    @Autowired
    private List<ProtocolSupportLoaderProvider> providers;
    @Autowired
    private ProtocolSupportLoader supportLoader;
    @Autowired
    private FileManager fileManager;

    @PostMapping(value={"/{id}/_deploy"})
    @SaveAction
    @Operation(summary="\u53d1\u5e03\u534f\u8bae")
    public Mono<Boolean> deploy(@PathVariable String id) {
        return this.service.deploy(id);
    }

    @PostMapping(value={"/{id}/_un-deploy"})
    @SaveAction
    @Operation(summary="\u53d6\u6d88\u53d1\u5e03")
    public Mono<Boolean> unDeploy(@PathVariable String id) {
        return this.service.unDeploy(id);
    }

    @GetMapping(value={"/providers"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u652f\u6301\u7684\u534f\u8bae\u7c7b\u578b")
    public Flux<String> getProviders() {
        return Flux.fromIterable(this.providers).map(ProtocolSupportLoaderProvider::getProvider);
    }

    @GetMapping(value={"/supports"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u652f\u6301\u7684\u534f\u8bae")
    public Flux<ProtocolInfo> allProtocols() {
        return this.protocolSupports.getProtocols().map(ProtocolInfo::of);
    }

    @GetMapping(value={"/{id}/{transport}/configuration"})
    @QueryAction
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u534f\u8bae\u5bf9\u5e94\u4f7f\u7528\u4f20\u8f93\u534f\u8bae\u7684\u914d\u7f6e\u5143\u6570\u636e")
    public Mono<ConfigMetadata> getTransportConfiguration(@PathVariable @Parameter(description="\u534f\u8baeID") String id, @PathVariable @Parameter(description="\u4f20\u8f93\u534f\u8bae") String transport) {
        return this.protocolSupports.getProtocol(id).flatMap(support -> support.getConfigMetadata(Transport.of((String)transport)));
    }

    @GetMapping(value={"/{id}/{transport}/metadata"})
    @QueryAction
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u534f\u8bae\u8bbe\u7f6e\u7684\u9ed8\u8ba4\u7269\u6a21\u578b")
    public Mono<String> getDefaultMetadata(@PathVariable @Parameter(description="\u534f\u8baeID") String id, @PathVariable @Parameter(description="\u4f20\u8f93\u534f\u8bae") String transport) {
        return this.protocolSupports.getProtocol(id).flatMap(support -> support.getDefaultMetadata(Transport.of((String)transport)).flatMap(metadata -> support.getMetadataCodec().encode(metadata))).defaultIfEmpty((Object)"{}");
    }

    @GetMapping(value={"/{id}/transports"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u534f\u8bae\u652f\u6301\u7684\u4f20\u8f93\u534f\u8bae")
    public Flux<TransportInfo> getAllTransport(@PathVariable @Parameter(description="\u534f\u8baeID") String id) {
        return this.protocolSupports.getProtocol(id).flatMapMany(ProtocolSupport::getSupportedTransport).distinct().map(TransportInfo::of);
    }

    @PostMapping(value={"/convert"})
    @QueryAction
    @Hidden
    public Mono<ProtocolDetail> convertToDetail(@RequestBody Mono<ProtocolSupportEntity> entity) {
        return entity.map(ProtocolSupportEntity::toDeployDefinition).doOnNext(def -> def.setId("_debug")).flatMap(def -> this.supportLoader.load(def)).flatMap(ProtocolDetail::of);
    }

    @PostMapping(value={"/decode"})
    @SaveAction
    @Hidden
    public Mono<String> decode(@RequestBody Mono<ProtocolDecodeRequest> entity) {
        return entity.flatMapMany(request -> {
            ProtocolSupportDefinition supportEntity = request.getEntity().toDeployDefinition();
            supportEntity.setId("_debug");
            return this.supportLoader.load(supportEntity).flatMapMany(protocol -> request.getRequest().doDecode((ProtocolSupport)protocol, null));
        }).collectList().map(JSON::toJSONString).onErrorResume(err -> Mono.just((Object)StringUtils.throwable2String((Throwable)err)));
    }

    @PostMapping(value={"/encode"})
    @SaveAction
    @Hidden
    public Mono<String> encode(@RequestBody Mono<ProtocolEncodeRequest> entity) {
        return entity.flatMapMany(request -> {
            ProtocolSupportDefinition supportEntity = request.getEntity().toDeployDefinition();
            supportEntity.setId("_debug");
            return this.supportLoader.load(supportEntity).flatMapMany(protocol -> request.getRequest().doEncode((ProtocolSupport)protocol, null));
        }).collectList().map(JSON::toJSONString).onErrorResume(err -> Mono.just((Object)StringUtils.throwable2String((Throwable)err)));
    }

    @GetMapping(value={"/units"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u5355\u4f4d\u6570\u636e")
    public Flux<ValueUnit> allUnits() {
        return Flux.fromIterable((Iterable)ValueUnits.getAllUnit());
    }

    @GetMapping(value={"/supports/{transport}"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u652f\u6301\u6307\u5b9a\u4f20\u8f93\u534f\u8bae\u7684\u6d88\u606f\u534f\u8bae")
    public Flux<ProtocolInfo> getSupportTransportProtocols(@PathVariable String transport, @Parameter(hidden=true) QueryParamEntity query) {
        return this.protocolSupports.getProtocols().collectMap(ProtocolSupport::getId).flatMapMany(protocols -> ((ReactiveQuery)this.service.createQuery().setParam((QueryParam)query)).fetch().index().flatMap(tp2 -> Mono.justOrEmpty(protocols.get(((ProtocolSupportEntity)((Object)((Object)((Object)tp2.getT2())))).getId())).filterWhen(support -> support.getSupportedTransport().filter(t -> t.isSame(transport)).hasElements()).map(ProtocolInfo::of).map(protocolInfo -> Tuples.of((Object)tp2.getT1(), (Object)protocolInfo)))).sort(Comparator.comparingLong(Tuple2::getT1)).map(Tuple2::getT2);
    }

    @GetMapping(value={"/{id}/transport/{transport}"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u6d88\u606f\u534f\u8bae\u5bf9\u5e94\u7684\u4f20\u8f93\u534f\u8bae\u4fe1\u606f")
    public Mono<TransportDetail> getTransportDetail(@PathVariable @Parameter(description="\u534f\u8baeID") String id, @PathVariable @Parameter(description="\u4f20\u8f93\u534f\u8bae") String transport) {
        return this.protocolSupports.getProtocol(id).onErrorMap(e -> new BusinessException("error.unable_to_load_protocol_by_access_id", 404, new Object[]{id})).flatMapMany(protocol -> protocol.getSupportedTransport().filter(trans -> trans.isSame(transport)).distinct().flatMap(_transport -> TransportDetail.of((ProtocolSupport)protocol, (Transport)_transport))).singleOrEmpty();
    }

    @PostMapping(value={"/{id}/detail"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u534f\u8bae\u8be6\u60c5")
    public Mono<ProtocolDetail> protocolDetail(@PathVariable String id) {
        return this.protocolSupports.getProtocol(id).onErrorMap(e -> new BusinessException("error.unable_to_load_protocol_by_access_id", 404, new Object[]{id})).flatMap(ProtocolDetail::of);
    }

    @PostMapping(value={"/default-protocol/_save"})
    @SaveAction
    @Operation(summary="\u4fdd\u5b58\u9ed8\u8ba4\u534f\u8bae")
    public Mono<Void> saveDefaultProtocol() {
        String defaultProtocolName = "JetLinks\u5b98\u65b9\u534f\u8bae";
        String fileNeme = "jetlinks-official-protocol-3.0-SNAPSHOT.jar";
        return this.fileManager.saveFile(fileNeme, DataBufferUtils.read((org.springframework.core.io.Resource)new ClassPathResource(fileNeme), (DataBufferFactory)new NettyDataBufferFactory(ByteBufAllocator.DEFAULT), (int)1024), new FileOption[0]).flatMap(fileInfo -> {
            HashMap<String, Object> conf = new HashMap<String, Object>();
            conf.put("fileId", fileInfo.getId());
            conf.put("provider", "org.jetlinks.protocol.official.JetLinksProtocolSupportProvider");
            conf.put("location", fileInfo.getAccessUrl());
            ProtocolSupportEntity entity = new ProtocolSupportEntity();
            entity.setId(DigestUtils.md5Hex((String)defaultProtocolName));
            entity.setType("jar");
            entity.setName(defaultProtocolName);
            entity.setState((byte)1);
            entity.setDescription("JetLinks\u5b98\u65b9\u534f\u8bae\u5305");
            entity.setConfiguration(conf);
            return this.getService().save((Object)entity);
        }).then();
    }

    public LocalProtocolSupportService getService() {
        return this.service;
    }
}

