/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service.term;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.AbstractTermsFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.TermFragmentBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.AbstractTermFragmentBuilder;
import org.hswebframework.web.api.crud.entity.TermExpressionParser;
import org.springframework.stereotype.Component;

@Component
public class DeviceTagTerm
extends AbstractTermFragmentBuilder {
    public static final String termType = "dev-tag";
    static WhereBuilder builder = new WhereBuilder();

    public DeviceTagTerm() {
        super(termType, "\u6839\u636e\u8bbe\u5907\u6807\u7b7e\u67e5\u8be2\u8bbe\u5907");
    }

    private void acceptTerm(boolean and, RDBColumnMetadata column, PrepareSqlFragments fragments, String terms) {
        if (terms.startsWith("[")) {
            this.acceptTerm(and, fragments, JSON.parseArray((String)terms, Map.class));
        } else if (terms.startsWith("{")) {
            this.acceptTerm(and, fragments, (Map<?, ?>)JSON.parseObject((String)terms));
        } else if (terms.contains(":") && !terms.contains(" ")) {
            List<Map<String, String>> tags = Stream.of(terms.split("[,]")).map(str -> str.split("[:]")).map(str -> {
                HashMap<String, String> tag = new HashMap<String, String>();
                tag.put("key", str[0]);
                tag.put("value", ((String[])str).length > 1 ? str[1] : null);
                return tag;
            }).collect(Collectors.toList());
            this.acceptTerm(and, fragments, tags);
        } else {
            List tagKeys = TermExpressionParser.parse((String)terms);
            fragments.addSql(new String[]{"and ("}).addFragments(builder.createTermFragments(column, (List<Term>)tagKeys)).addSql(new String[]{")"});
        }
    }

    private void acceptTerm(boolean and, PrepareSqlFragments fragments, Map<?, ?> terms) {
        this.acceptTerm(and, fragments, terms.entrySet().stream().map(e -> {
            HashMap<String, String> tag = new HashMap<String, String>();
            tag.put("key", String.valueOf(e.getKey()));
            tag.put("value", String.valueOf(e.getValue()));
            return tag;
        }).collect(Collectors.toList()));
    }

    private void acceptTerm(boolean and, PrepareSqlFragments fragments, List<Map<String, String>> tags) {
        int len = 0;
        fragments.addSql(new String[]{"and ("});
        for (Map<String, String> tag : tags) {
            if (len++ > 0) {
                fragments.addSql(new String[]{and ? "and" : "or"});
            }
            fragments.addSql(new String[]{"(d.key = ? and d.value like ?)"}).addParameter(new Object[]{tag.get("key"), tag.get("value")});
        }
        if (tags.isEmpty()) {
            fragments.addSql(new String[]{"1=2"});
        }
        fragments.addSql(new String[]{")"});
    }

    public SqlFragments createFragments(String columnFullName, RDBColumnMetadata column, Term term) {
        PrepareSqlFragments fragments = PrepareSqlFragments.of();
        fragments.addSql(new String[]{"exists(select 1 from ", this.getTableName("dev_device_tags", column), " d where d.device_id =", columnFullName});
        Object value = term.getValue();
        boolean and = term.getOptions().contains("and");
        if (value instanceof Map) {
            this.acceptTerm(and, fragments, (Map)value);
        } else if (value instanceof List) {
            this.acceptTerm(and, fragments, (List)value);
        } else {
            this.acceptTerm(and, column, fragments, String.valueOf(value));
        }
        fragments.addSql(new String[]{")"});
        return fragments;
    }

    static class WhereBuilder
    extends AbstractTermsFragmentBuilder<RDBColumnMetadata> {
        WhereBuilder() {
        }

        protected SqlFragments createTermFragments(RDBColumnMetadata parameter, Term term) {
            PrepareSqlFragments sqlFragments = PrepareSqlFragments.of();
            sqlFragments.addSql(new String[]{"(d.key = ?"}).addParameter(new Object[]{term.getColumn()}).addSql(new String[]{"and"}).addFragments(((TermFragmentBuilder)parameter.findFeatureNow(TermFragmentBuilder.createFeatureId((String)term.getTermType()))).createFragments("d.value", parameter, term)).addSql(new String[]{")"});
            return sqlFragments;
        }

        protected SqlFragments createTermFragments(RDBColumnMetadata parameter, List<Term> terms) {
            return super.createTermFragments((Object)parameter, terms);
        }
    }
}

