/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service.data;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.Interval;
import org.jetlinks.community.device.entity.DeviceEvent;
import org.jetlinks.community.device.entity.DeviceOperationLogEntity;
import org.jetlinks.community.device.entity.DeviceProperty;
import org.jetlinks.community.timeseries.query.Aggregation;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.joda.time.DateTime;
import org.reactivestreams.Publisher;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DeviceDataService {
    public static final ConfigKey<String> STORE_POLICY_CONFIG_KEY = ConfigKey.of((String)"storePolicy", (String)"\u5b58\u50a8\u7b56\u7565", String.class);

    public Mono<Void> registerMetadata(@Nonnull String var1, @Nonnull DeviceMetadata var2);

    public Mono<Void> reloadMetadata(@Nonnull String var1, @Nonnull DeviceMetadata var2);

    @Nonnull
    default public Mono<Void> saveDeviceMessage(@Nonnull Collection<DeviceMessage> message) {
        return this.saveDeviceMessage((Publisher<DeviceMessage>)Flux.fromIterable(message));
    }

    @Nonnull
    public Mono<Void> saveDeviceMessage(@Nonnull DeviceMessage var1);

    @Nonnull
    public Mono<Void> saveDeviceMessage(@Nonnull Publisher<DeviceMessage> var1);

    @Nonnull
    public Flux<DeviceProperty> queryEachOneProperties(@Nonnull String var1, @Nonnull QueryParamEntity var2, String ... var3);

    @Nonnull
    public Flux<DeviceProperty> queryEachProperties(@Nonnull String var1, @Nonnull QueryParamEntity var2, String ... var3);

    @Nonnull
    public Flux<DeviceProperty> queryProperty(@Nonnull String var1, @Nonnull QueryParamEntity var2, String ... var3);

    public Flux<AggregationData> aggregationPropertiesByProduct(@Nonnull String var1, @Nonnull AggregationRequest var2, DevicePropertyAggregation ... var3);

    public Flux<AggregationData> aggregationPropertiesByDevice(@Nonnull String var1, @Nonnull AggregationRequest var2, DevicePropertyAggregation ... var3);

    @Nonnull
    public Mono<PagerResult<DeviceProperty>> queryPropertyPage(@Nonnull String var1, @Nonnull String var2, @Nonnull QueryParamEntity var3);

    public Mono<PagerResult<DeviceOperationLogEntity>> queryDeviceMessageLog(@Nonnull String var1, @Nonnull QueryParamEntity var2);

    @Nonnull
    public Flux<DeviceEvent> queryEvent(@Nonnull String var1, @Nonnull String var2, @Nonnull QueryParamEntity var3, boolean var4);

    @Nonnull
    public Mono<PagerResult<DeviceEvent>> queryEventPage(@Nonnull String var1, @Nonnull String var2, @Nonnull QueryParamEntity var3, boolean var4);

    @Nonnull
    default public Mono<PagerResult<DeviceEvent>> queryEventPage(@Nonnull String deviceId, @Nonnull String event, @Nonnull QueryParamEntity query) {
        return this.queryEventPage(deviceId, event, query, false);
    }

    public static class AggregationRequest {
        @Schema(description="\u95f4\u9694,\u5982: 1d", type="string", defaultValue="1d")
        Interval interval = Interval.ofDays((int)1);
        @Schema(defaultValue="\u65f6\u95f4\u683c\u5f0f,\u5982:yyyy-MM-dd", description="yyyy-MM-dd")
        String format = "yyyy-MM-dd";
        @Schema(description="\u65f6\u95f4\u4ece,\u5982: 2020-09-01 00:00:00,\u652f\u6301\u8868\u8fbe\u5f0f: now-1d")
        Date from = new DateTime().plusMonths(-1).withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).toDate();
        @Schema(description="\u65f6\u95f4\u5230,\u5982: 2020-09-30 00:00:00,\u652f\u6301\u8868\u8fbe\u5f0f: now-1d")
        Date to = new DateTime().withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).toDate();
        @Schema(description="\u5b9e\u4f8b\u9650\u5236")
        int limit = 30;
        @Schema(description="\u8fc7\u6ee4\u6761\u4ef6")
        QueryParamEntity filter = QueryParamEntity.of();

        public AggregationRequest copy() {
            return new AggregationRequest(this.interval, this.format, this.from, this.to, this.limit, this.filter.clone());
        }

        @Hidden
        public void setQuery(QueryParamEntity filter) {
            this.setFilter(filter);
        }

        public static AggregationRequestBuilder builder() {
            return new AggregationRequestBuilder();
        }

        public Interval getInterval() {
            return this.interval;
        }

        public String getFormat() {
            return this.format;
        }

        public Date getFrom() {
            return this.from;
        }

        public Date getTo() {
            return this.to;
        }

        public int getLimit() {
            return this.limit;
        }

        public QueryParamEntity getFilter() {
            return this.filter;
        }

        public void setInterval(Interval interval) {
            this.interval = interval;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public void setFrom(Date from) {
            this.from = from;
        }

        public void setTo(Date to) {
            this.to = to;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public void setFilter(QueryParamEntity filter) {
            this.filter = filter;
        }

        public AggregationRequest(Interval interval, String format, Date from, Date to, int limit, QueryParamEntity filter) {
            this.interval = interval;
            this.format = format;
            this.from = from;
            this.to = to;
            this.limit = limit;
            this.filter = filter;
        }

        public AggregationRequest() {
        }

        public static class AggregationRequestBuilder {
            private Interval interval;
            private String format;
            private Date from;
            private Date to;
            private int limit;
            private QueryParamEntity filter;

            AggregationRequestBuilder() {
            }

            public AggregationRequestBuilder interval(Interval interval) {
                this.interval = interval;
                return this;
            }

            public AggregationRequestBuilder format(String format) {
                this.format = format;
                return this;
            }

            public AggregationRequestBuilder from(Date from) {
                this.from = from;
                return this;
            }

            public AggregationRequestBuilder to(Date to) {
                this.to = to;
                return this;
            }

            public AggregationRequestBuilder limit(int limit) {
                this.limit = limit;
                return this;
            }

            public AggregationRequestBuilder filter(QueryParamEntity filter) {
                this.filter = filter;
                return this;
            }

            public AggregationRequest build() {
                return new AggregationRequest(this.interval, this.format, this.from, this.to, this.limit, this.filter);
            }

            public String toString() {
                return "DeviceDataService.AggregationRequest.AggregationRequestBuilder(interval=" + this.interval + ", format=" + this.format + ", from=" + this.from + ", to=" + this.to + ", limit=" + this.limit + ", filter=" + this.filter + ")";
            }
        }
    }

    public static class DevicePropertyAggregation {
        @Schema(description="\u5c5e\u6027ID")
        private String property;
        @Schema(description="\u522b\u540d,\u9ed8\u8ba4\u548cproperty\u4e00\u81f4")
        private String alias;
        @Schema(description="\u805a\u5408\u65b9\u5f0f,\u652f\u6301(count,sum,max,min,avg)", type="string")
        private Aggregation agg;

        public String getAlias() {
            if (StringUtils.isEmpty((Object)this.alias)) {
                return this.property;
            }
            return this.alias;
        }

        public String getProperty() {
            return this.property;
        }

        public Aggregation getAgg() {
            return this.agg;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public void setAgg(Aggregation agg) {
            this.agg = agg;
        }

        public DevicePropertyAggregation(String property, String alias, Aggregation agg) {
            this.property = property;
            this.alias = alias;
            this.agg = agg;
        }

        public DevicePropertyAggregation() {
        }
    }
}

