/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.measurements;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.MeasurementValue;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.community.gateway.DeviceMessageUtils;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DevicePropertiesMeasurement
extends StaticMeasurement {
    private static final Logger log = LoggerFactory.getLogger(DevicePropertiesMeasurement.class);
    private final EventBus eventBus;
    private final DeviceMetadata metadata;
    private final DeviceDataService dataService;
    private final String productId;
    static ConfigMetadata configMetadata = new DefaultConfigMetadata().add("deviceId", "\u8bbe\u5907", "\u6307\u5b9a\u8bbe\u5907", (DataType)new StringType().expand("selector", (Object)"device-selector"));

    public DevicePropertiesMeasurement(String productId, EventBus eventBus, DeviceDataService dataService, DeviceMetadata deviceMetadata) {
        super(MeasurementDefinition.of((String)"properties", (String)"\u5c5e\u6027\u8bb0\u5f55"));
        this.productId = productId;
        this.eventBus = eventBus;
        this.metadata = deviceMetadata;
        this.dataService = dataService;
        this.addDimension(new RealTimeDevicePropertyDimension());
        this.addDimension(new HistoryDevicePropertyDimension());
    }

    Flux<SimpleMeasurementValue> fromHistory(String deviceId, int history, Set<String> properties) {
        return history <= 0 ? Flux.empty() : ((Flux)QueryParamEntity.newQuery().doPaging(0, history).execute(q -> this.dataService.queryEachProperties(deviceId, (QueryParamEntity)q, properties.toArray(new String[0])))).map(data -> SimpleMeasurementValue.of((Object)data, (long)data.getTimestamp())).sort(MeasurementValue.sort());
    }

    Map<String, Object> createValue(String property, Object value) {
        return this.metadata.getProperty(property).map(meta -> {
            HashMap<String, Object> values = new HashMap<String, Object>();
            DataType type = meta.getValueType();
            Object val = type instanceof Converter ? ((Converter)type).convert(value) : value;
            values.put("formatValue", type.format(val));
            values.put("value", val);
            values.put("property", property);
            return values;
        }).orElseGet(() -> {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("formatValue", value);
            values.put("value", value);
            values.put("property", property);
            return values;
        });
    }

    Flux<MeasurementValue> fromRealTime(String deviceId, Set<String> properties) {
        Subscription subscription = Subscription.of((String)"realtime-device-properties-measurement", (String[])new String[]{"/device/" + this.productId + "/" + deviceId + "/message/property/report", "/device/" + this.productId + "/" + deviceId + "/message/property/*/reply"}, (Subscription.Feature[])new Subscription.Feature[]{Subscription.Feature.local, Subscription.Feature.broker});
        List props = this.metadata.getProperties();
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        int idx = 0;
        for (PropertyMetadata prop : props) {
            if (!properties.isEmpty() && !properties.contains(prop.getId())) continue;
            index.put(prop.getId(), idx++);
        }
        return this.eventBus.subscribe(subscription, DeviceMessage.class).flatMap(msg -> Mono.justOrEmpty((Optional)DeviceMessageUtils.tryGetProperties((DeviceMessage)msg))).flatMap(map -> Flux.fromIterable(map.entrySet()).sort(Comparator.comparingInt(e -> index.getOrDefault(e.getKey(), 0)))).map(kv -> SimpleMeasurementValue.of(this.createValue((String)kv.getKey(), kv.getValue()), (long)System.currentTimeMillis())).onErrorContinue((err, v) -> log.error(err.getMessage(), err));
    }

    static Set<String> getPropertiesFromParameter(MeasurementParameter parameter) {
        return parameter.get("properties").map(CastUtils::castArray).orElse(Collections.emptyList()).stream().map(String::valueOf).collect(Collectors.toSet());
    }

    private class RealTimeDevicePropertyDimension
    implements MeasurementDimension {
        private RealTimeDevicePropertyDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.realTime;
        }

        public DataType getValueType() {
            return new ObjectType().addProperty("property", "\u5c5e\u6027", (DataType)StringType.GLOBAL).addProperty("value", "\u503c", (DataType)StringType.GLOBAL).addProperty("formatValue", "\u683c\u5f0f\u5316\u503c", (DataType)StringType.GLOBAL);
        }

        public ConfigMetadata getParams() {
            return configMetadata;
        }

        public boolean isRealTime() {
            return true;
        }

        public Flux<MeasurementValue> getValue(MeasurementParameter parameter) {
            return Mono.justOrEmpty((Optional)parameter.getString("deviceId")).flatMapMany(deviceId -> {
                int history = parameter.getInt("history").orElse(0);
                return Flux.concat((Publisher[])new Publisher[]{DevicePropertiesMeasurement.this.fromHistory((String)deviceId, history, DevicePropertiesMeasurement.getPropertiesFromParameter(parameter)), DevicePropertiesMeasurement.this.fromRealTime((String)deviceId, DevicePropertiesMeasurement.getPropertiesFromParameter(parameter))});
            });
        }
    }

    private class HistoryDevicePropertyDimension
    implements MeasurementDimension {
        private HistoryDevicePropertyDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.history;
        }

        public DataType getValueType() {
            return new ObjectType().addProperty("property", "\u5c5e\u6027", (DataType)StringType.GLOBAL).addProperty("value", "\u503c", (DataType)StringType.GLOBAL).addProperty("formatValue", "\u683c\u5f0f\u5316\u503c", (DataType)StringType.GLOBAL);
        }

        public ConfigMetadata getParams() {
            return configMetadata;
        }

        public boolean isRealTime() {
            return false;
        }

        public Flux<MeasurementValue> getValue(MeasurementParameter parameter) {
            return Mono.justOrEmpty((Optional)parameter.getString("deviceId")).flatMapMany(deviceId -> {
                int history = parameter.getInt("history").orElse(1);
                return DevicePropertiesMeasurement.this.fromHistory((String)deviceId, history, DevicePropertiesMeasurement.getPropertiesFromParameter(parameter));
            });
        }
    }
}

