/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.measurements;

import javax.annotation.PostConstruct;
import org.jetlinks.community.dashboard.DashboardObject;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.measurements.DeviceDashboard;
import org.jetlinks.community.device.measurements.DeviceDashboardObject;
import org.jetlinks.community.device.service.LocalDeviceProductService;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.event.EventBus;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DeviceDynamicDashboard
implements DeviceDashboard {
    private final LocalDeviceProductService productService;
    private final DeviceRegistry registry;
    private final EventBus eventBus;
    private final DeviceDataService dataService;

    public DeviceDynamicDashboard(LocalDeviceProductService productService, DeviceRegistry registry, DeviceDataService deviceDataService, EventBus eventBus) {
        this.productService = productService;
        this.registry = registry;
        this.eventBus = eventBus;
        this.dataService = deviceDataService;
    }

    @PostConstruct
    public void init() {
    }

    public Flux<DashboardObject> getObjects() {
        return this.productService.createQuery().fetch().flatMap(this::convertObject);
    }

    public Mono<DashboardObject> getObject(String id) {
        return this.productService.findById(id).flatMap(this::convertObject);
    }

    protected Mono<DeviceDashboardObject> convertObject(DeviceProductEntity product) {
        return this.registry.getProduct(product.getId()).map(operator -> DeviceDashboardObject.of(product.getId(), product.getName(), operator, this.eventBus, this.dataService));
    }
}

