/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.function;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.Conditional;
import org.hswebframework.ezorm.core.NestConditional;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.relation.RelationManagerHolder;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorProvider;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorSpec;
import org.jetlinks.core.things.relation.ObjectSpec;
import org.jetlinks.core.things.relation.RelatedObject;
import org.jetlinks.core.things.relation.RelationObject;
import org.jetlinks.core.things.relation.RelationSpec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RelationDeviceSelectorProvider
implements DeviceSelectorProvider {
    public String getProvider() {
        return "relation";
    }

    public String getName() {
        return "\u6309\u5173\u7cfb";
    }

    public <T extends Conditional<T>> Mono<NestConditional<T>> applyCondition(DeviceSelectorSpec source, Map<String, Object> ctx, NestConditional<T> conditional) {
        return this.applyCondition((Flux<String>)source.resolve(ctx).map(String::valueOf), (Flux<RelationSpec>)Flux.fromIterable((Iterable)source.getSelectorValues()).map(RelationSpec::of), conditional);
    }

    public <T extends Conditional<T>> Mono<NestConditional<T>> applyCondition(List<?> args, NestConditional<T> conditional) {
        Flux relations = Flux.fromIterable(args).skip(1L).map(RelationSpec::of);
        return this.applyCondition((Flux<String>)Flux.just((Object)String.valueOf(args.get(0))), (Flux<RelationSpec>)relations, conditional);
    }

    public <T extends Conditional<T>> Mono<NestConditional<T>> applyCondition(Flux<String> source, Flux<RelationSpec> relations, NestConditional<T> conditional) {
        return source.flatMap(deviceId -> relations.flatMap(spec -> {
            ObjectSpec objectSpec = new ObjectSpec();
            objectSpec.setObjectType("device");
            objectSpec.setObjectId(deviceId);
            objectSpec.setRelated(spec);
            return RelationManagerHolder.getObjects((ObjectSpec)objectSpec).flatMap(obj -> {
                if (obj.getType().equals("device")) {
                    return Mono.just((Object)obj);
                }
                return obj.relations(true).get("device", ((RelatedObject)obj).getRelation(), new String[0]);
            });
        })).map(RelationObject::getId).collectList().filter(CollectionUtils::isNotEmpty).doOnNext(deviceIdList -> conditional.in(DeviceInstanceEntity::getId, (Collection)deviceIdList)).thenReturn(conditional);
    }
}

