/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.function;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.rule.engine.executor.DeviceSelector;
import org.jetlinks.community.rule.engine.executor.DeviceSelectorBuilder;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorProvider;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorProviders;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorSpec;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.reactor.ql.ReactorQL;
import org.jetlinks.reactor.ql.ReactorQLContext;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.springframework.data.util.Lazy;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorQLDeviceSelectorBuilder
implements DeviceSelectorBuilder {
    private final DeviceRegistry registry;
    private final ReactiveRepository<DeviceInstanceEntity, String> deviceRepository;

    public DeviceSelector createSelector(DeviceSelectorSpec spec) {
        DeviceSelectorProvider provider = (DeviceSelectorProvider)DeviceSelectorProviders.getProvider((String)spec.getSelector()).orElseThrow(() -> new UnsupportedOperationException("unsupported selector:" + spec.getSelector()));
        if (DeviceSelectorProviders.isFixed((DeviceSelectorSpec)spec)) {
            return ctx -> spec.resolveSelectorValues(ctx).map(String::valueOf).flatMap(arg_0 -> ((DeviceRegistry)this.registry).getDevice(arg_0));
        }
        Function lazy = provider.createLazy(spec, (Supplier)Lazy.of(() -> ((ReactiveQuery)this.deviceRepository.createQuery().select(new StaticMethodReferenceColumn[]{DeviceInstanceEntity::getId})).nest()));
        return context -> ((Mono)lazy.apply(context)).flatMapMany(ctd -> ((ReactiveQuery)ctd.end()).fetch().map(DeviceInstanceEntity::getId)).flatMap(arg_0 -> ((DeviceRegistry)this.registry).getDevice(arg_0));
    }

    public ReactorQLDeviceSelectorBuilder(DeviceRegistry registry, ReactiveRepository<DeviceInstanceEntity, String> deviceRepository) {
        this.registry = registry;
        this.deviceRepository = deviceRepository;
    }

    static class ReactorQLDeviceSelector
    implements DeviceSelector {
        private final ReactorQL ql;
        private final DeviceRegistry registry;

        public Flux<DeviceOperator> select(Map<String, Object> context) {
            return this.ql.start(ReactorQLContext.ofDatasource(r -> Flux.just((Object)context)).bindAll(context)).map(ReactorQLRecord::asMap).flatMap(res -> this.registry.getDevice((String)res.get("id")));
        }

        public ReactorQLDeviceSelector(ReactorQL ql, DeviceRegistry registry) {
            this.ql = ql;
            this.registry = registry;
        }
    }
}

