package net.zstong.awump.monitoring.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.zstong.awump.base.entity.BaseEntity;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
* @author yuanhc
* @date 2023-07-07
*/
@Getter
@Setter
@Table(name="aw_monitoring_device")
@Comment("监控设备信息")
@EnableEntityEvent
public class AwMonitoringDeviceEntity extends BaseEntity<String> {



    /** 所属单位 */
    @Schema(description = "所属单位")
    @Column(name = "institution_id_",length =64 )
    private String institutionId;


    /** 所属库房 */
    @Schema(description = "所属库房")
    @Column(name = "warehouse_id_",length =64 )
    private String warehouseId;


    /** 所属监控区域 */
    @Schema(description = "所属监控区域")
    @Column(name = "area_id_",length =64 )
    private String areaId;


    /** 设备名称 */
    @Schema(description = "设备名称")
    @Column(name = "name_",nullable = false,length =256 )
    @NotBlank(message = "设备名称不能为空", groups = CreateGroup.class)
    private String name;


    /** 设备编码 */
    @Schema(description = "设备编码")
    @Column(name = "code_",length =64 )
    private String code;


    /** 设备类别 */
    @Schema(description = "设备类别")
    @Column(name = "device_type_",length =64 )
    private String deviceType;


    /** 设备型号 */
    @Schema(description = "设备型号")
    @Column(name = "model_",length =32 )
    private String model;


    /** 品牌 */
    @Schema(description = "品牌")
    @Column(name = "brand_",length =200 )
    private String brand;


    /** 访问地址 */
    @Schema(description = "访问地址")
    @Column(name = "server_addr",length =32 )
    private String serverAddr;


    /** IP地址 */
    @Schema(description = "IP地址")
    @Column(name = "ip_",length =32 )
    private String ip;


    /** 访问用户名 */
    @Schema(description = "访问用户名")
    @Column(name = "username_",length =32 )
    private String username;


    /** 访问密码 */
    @Schema(description = "访问密码")
    @Column(name = "pwd_",length =64 )
    private String pwd;


    /** 设备序号 */
    @Schema(description = "设备序号")
    @Column(name = "device_sn_",length =64 )
    private String deviceSn;


    /** 设备序号 */
    @Schema(description = "父设备")
    @Column(name = "parent_id_",length =64 )
    private String parentId;


    /** 出厂日期 */
    @Schema(description = "出厂日期")
    @Column(name = "manufacture_date_")
     @JsonFormat(pattern="yyyy-MM-dd")
     private LocalDate manufactureDate;











}