package net.zstong.awump.monitoring.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.zstong.awump.base.entity.AwWarehouseEntity;
import net.zstong.awump.base.entity.BaseTreeSortEntity;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.springframework.beans.BeanUtils;

import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import java.time.LocalDate;
import java.util.List;

/**
 * @author yuanhc
 * @date 2023-07-07
 */
@Getter
@Setter
public class AwMonitoringAreaDeviceInfo extends BaseTreeSortEntity<String> {

    @Schema(description = "子节点")
    private List<AwMonitoringAreaDeviceInfo> children;

    /**
     * 所属单位
     */
    @Schema(description = "所属单位")
    private String institutionId;


    /**
     * 所属库房
     */
    @Schema(description = "所属库房")
    private String warehouseId;


    /**
     * 父ID
     */
    @Schema(description = "父ID")
    private String parentId;


    /**
     * 区域名称
     */
    @Schema(description = "名称")
    private String name;


    /**
     * 区域编码
     */
    @Schema(description = "编码")
    private String code;


    /**
     * 树层级
     */
    @Schema(description = "树层级")
    @Column(name = "_level")
    private Integer Level;


    /**
     * 树路径
     */
    @Schema(description = "树路径")
    @Column(name = "path", length = 128)
    private String path;


    /**
     * 树序号
     */
    @Schema(description = "树序号")
    @Column(name = "sort_index")
    private Long sortIndex;


    /**
     * 描述
     */
    @Schema(description = "描述")
    @Column(name = "describe_", length = 200)
    private String describe;




    /**
     * 所属监控区域
     */
    @Schema(description = "所属监控区域")
    private String areaId;


    /**
     * 设备类别
     */
    @Schema(description = "设备类别")
    private String deviceType;


    /**
     * 设备型号
     */
    @Schema(description = "设备型号")
    private String model;


    /**
     * 品牌
     */
    @Schema(description = "品牌")
    private String brand;


    /**
     * 访问地址
     */
    @Schema(description = "访问地址")
    private String serverAddr;


    /**
     * IP地址
     */
    @Schema(description = "IP地址")
    private String ip;


    /**
     * 访问用户名
     */
    @Schema(description = "访问用户名")
    private String username;


    /**
     * 访问密码
     */
    @Schema(description = "访问密码")
    private String pwd;


    /**
     * 设备序号
     */
    @Schema(description = "设备序号")
    private String deviceSn;


    /**
     * 出厂日期
     */
    @Schema(description = "出厂日期")
    private LocalDate manufactureDate;


    public static AwMonitoringAreaDeviceInfo of(AwMonitoringAreaEntity entity) {
        AwMonitoringAreaDeviceInfo info = new AwMonitoringAreaDeviceInfo();
        BeanUtils.copyProperties(entity, info);
        return info;
    }


    public static AwMonitoringAreaDeviceInfo of(AwMonitoringDeviceEntity entity) {
        AwMonitoringAreaDeviceInfo info = new AwMonitoringAreaDeviceInfo();
        BeanUtils.copyProperties(entity, info);
        return info;
    }


}