package net.zstong.awump.base.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;

import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author yuanhc
 * @date 2023-05-25
 */
@Getter
@Setter
@Table(name = "aw_region")
@Comment("库房区域信息")
@EnableEntityEvent
public class AwRegionEntity extends BaseTreeSortEntity<String> {

    @Schema(description = "子节点")
    private List<AwRegionEntity> children;

    @Schema(description = "单位数量")
    private Integer countInstitution;

    @Schema(description = "树节点是否可选")
    private boolean disabled = false;

    /**
     * 区域名称
     */
    @Schema(description = "区域名称")
    @Column(name = "name_", nullable = false, length = 256)
    @NotBlank(message = "区域名称不能为空", groups = CreateGroup.class)
    private String name;


    /**
     * 区域编码
     */
    @Schema(description = "区域编码")
    @Column(name = "code_", length = 64)
    private String code;


    /**
     * 区域类型
     */
    @Schema(description = "区域类型")
    @Column(name = "region_type_", length = 32)
    private String regionType;


    /**
     * 描述
     */
    @Schema(description = "描述")
    @Column(name = "describe_", length = 200)
    private String describe;


}