/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.configure.trace;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import org.jetlinks.community.configure.cluster.ClusterProperties;
import org.jetlinks.community.configure.trace.TraceExchangeFilterFunction;
import org.jetlinks.community.configure.trace.TraceProperties;
import org.jetlinks.community.configure.trace.TraceWebFilter;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.trace.EventBusSpanExporter;
import org.jetlinks.core.trace.TraceHolder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={TraceProperties.class})
public class TraceConfiguration {
    @Bean
    public TraceWebFilter traceWebFilter() {
        return new TraceWebFilter();
    }

    @Bean
    public SpanProcessor eventBusSpanExporter(EventBus eventBus) {
        return SimpleSpanProcessor.create((SpanExporter)EventBusSpanExporter.create((EventBus)eventBus));
    }

    @Bean
    public OpenTelemetry createTelemetry(ObjectProvider<SpanProcessor> spanProcessors, ClusterProperties clusterProperties, TraceProperties traceProperties) {
        SdkTracerProviderBuilder sdkTracerProvider = SdkTracerProvider.builder();
        spanProcessors.forEach(arg_0 -> ((SdkTracerProviderBuilder)sdkTracerProvider).addSpanProcessor(arg_0));
        traceProperties.buildProcessors().forEach(arg_0 -> ((SdkTracerProviderBuilder)sdkTracerProvider).addSpanProcessor(arg_0));
        SdkTracerProvider tracerProvider = sdkTracerProvider.setResource(Resource.builder().put("service.name", clusterProperties.getId()).build()).build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkTracerProvider)tracerProvider).close()));
        OpenTelemetrySdk telemetry = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).build();
        TraceHolder.setup((OpenTelemetry)telemetry);
        try {
            GlobalOpenTelemetry.set((OpenTelemetry)telemetry);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return telemetry;
    }

    @Bean
    public WebClientCustomizer traceWebClientCustomizer(OpenTelemetry openTelemetry) {
        return builder -> builder.filters(filters -> {
            if (!filters.contains(TraceExchangeFilterFunction.instance())) {
                filters.add(TraceExchangeFilterFunction.instance());
            }
        });
    }
}

