/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.configure.cluster;

import io.netty.util.concurrent.FastThreadLocal;
import io.scalecube.cluster.transport.api.Message;
import io.scalecube.cluster.transport.api.MessageCodec;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTMessageCodec
implements MessageCodec {
    private final FastThreadLocal<FSTConfiguration> configuration;

    public FSTMessageCodec(final Supplier<FSTConfiguration> supplier) {
        this(new FastThreadLocal<FSTConfiguration>(){

            protected FSTConfiguration initialValue() {
                return (FSTConfiguration)supplier.get();
            }
        });
    }

    public Message deserialize(InputStream stream) throws Exception {
        Message message = Message.builder().build();
        try (FSTObjectInput input = ((FSTConfiguration)this.configuration.get()).getObjectInput(stream);){
            message.readExternal((ObjectInput)input);
        }
        return message;
    }

    public void serialize(Message message, OutputStream stream) throws Exception {
        try (FSTObjectOutput output = ((FSTConfiguration)this.configuration.get()).getObjectOutput(stream);){
            message.writeExternal((ObjectOutput)output);
        }
    }

    public FSTMessageCodec(FastThreadLocal<FSTConfiguration> configuration) {
        this.configuration = configuration;
    }
}

