/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.topic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetlinks.core.utils.StringBuilderUtils;

public interface Topics {
    public static final String allDeviceRegisterEvent = "/_sys/registry-device/*/register";
    public static final String allDeviceUnRegisterEvent = "/_sys/registry-device/*/unregister";
    public static final String allDeviceMetadataChangedEvent = "/_sys/registry-device/*/metadata";
    public static final String allProductRegisterEvent = "/_sys/registry-product/*/register";
    public static final String allProductUnRegisterEvent = "/_sys/registry-product/*/unregister";
    public static final String allProductMetadataChangedEvent = "/_sys/registry-product/*/metadata";

    public static String creator(String creatorId, String topic) {
        return StringBuilderUtils.buildString((Object)creatorId, (Object)topic, Topics::creator);
    }

    public static void creator(String creatorId, String topic, StringBuilder builder) {
        builder.append("/user/").append(creatorId);
        if (topic.charAt(0) != '/') {
            builder.append('/');
        }
        builder.append(topic);
    }

    public static List<String> bindings(List<Map<String, Object>> bindings, String topic) {
        ArrayList<String> topics = new ArrayList<String>(bindings.size());
        for (Map<String, Object> binding : bindings) {
            topics.add(Topics.binding(String.valueOf(binding.get("type")), String.valueOf(binding.get("id")), topic));
        }
        return topics;
    }

    public static void binding(String type, String id, String topic, StringBuilder builder) {
        builder.append('/').append(type).append('/').append(id);
        if (topic.charAt(0) != '/') {
            builder.append('/');
        }
        builder.append(topic);
    }

    public static String binding(String type, String id, String topic) {
        return StringBuilderUtils.buildString((Object)type, (Object)id, (Object)topic, Topics::binding);
    }

    @Deprecated
    public static String tenantMember(String memberId, String topic) {
        if (!topic.startsWith("/")) {
            topic = "/" + topic;
        }
        return String.join((CharSequence)"", "/member/", memberId, topic);
    }

    @Deprecated
    public static List<String> tenantMembers(List<String> members, String topic) {
        return members.stream().map(id -> Topics.tenantMember(id, topic)).collect(Collectors.toList());
    }

    @Generated
    public static String deviceRegisterEvent(String deviceId) {
        return Topics.registryDeviceEvent(deviceId, "register");
    }

    @Generated
    public static String deviceUnRegisterEvent(String deviceId) {
        return Topics.registryDeviceEvent(deviceId, "unregister");
    }

    @Generated
    public static String deviceMetadataChangedEvent(String deviceId) {
        return Topics.registryDeviceEvent(deviceId, "metadata");
    }

    @Generated
    public static String productRegisterEvent(String deviceId) {
        return Topics.registryProductEvent(deviceId, "register");
    }

    @Generated
    public static String productUnRegisterEvent(String deviceId) {
        return Topics.registryProductEvent(deviceId, "unregister");
    }

    @Generated
    public static String productMetadataChangedEvent(String deviceId) {
        return Topics.registryProductEvent(deviceId, "metadata");
    }

    public static String registryDeviceEvent(String deviceId, String event) {
        return "/_sys/registry-device/" + deviceId + "/" + event;
    }

    public static String registryProductEvent(String deviceId, String event) {
        return "/_sys/registry-product/" + deviceId + "/" + event;
    }

    public static String alarm(String targetType, String targetId, String alarmId) {
        return String.join((CharSequence)"", "/alarm/", targetType, "/", targetId, "/", alarmId, "/record");
    }
}

