/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.reference;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.community.reference.DataReferenceInfo;
import org.jetlinks.community.reference.DataReferencedException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DataReferenceManager {
    public static final String TYPE_DEVICE_GATEWAY = "device-gateway";
    public static final String TYPE_NETWORK = "network";
    public static final String TYPE_RELATION = "relation";
    public static final String TYPE_PROTOCOL = "protocol";

    public Mono<Boolean> isReferenced(String var1, String var2);

    public Flux<DataReferenceInfo> getReferences(String var1, String var2);

    public Flux<DataReferenceInfo> getReferences(String var1);

    default public Mono<Void> assertNotReferenced(String dataType, String dataId) {
        return this.getReferences(dataType, dataId).collectList().filter(CollectionUtils::isNotEmpty).flatMap(list -> Mono.error((Throwable)((Object)new DataReferencedException(dataType, dataId, (List<DataReferenceInfo>)list))));
    }
}

