/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.config.ConfigManager;
import org.jetlinks.community.config.ConfigPropertyDef;
import org.jetlinks.community.config.ConfigScope;
import org.jetlinks.community.config.ConfigScopeManager;
import org.jetlinks.community.config.entity.ConfigEntity;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleConfigManager
implements ConfigManager,
ConfigScopeManager {
    private final Map<ConfigScope, Set<ConfigPropertyDef>> scopes = new ConcurrentHashMap<ConfigScope, Set<ConfigPropertyDef>>();
    private final ReactiveRepository<ConfigEntity, String> repository;

    @Override
    public void addScope(ConfigScope scope, List<ConfigPropertyDef> properties) {
        this.scopes.computeIfAbsent(scope, ignore -> new LinkedHashSet()).addAll(properties);
    }

    @Override
    public Flux<ConfigScope> getScopes() {
        return Flux.fromIterable(this.scopes.keySet());
    }

    @Override
    public Mono<ConfigScope> getScope(String scope) {
        return this.getScopes().filter(configScope -> Objects.equals(configScope.getId(), scope)).take(1L).singleOrEmpty();
    }

    @Override
    public Flux<ConfigPropertyDef> getPropertyDef(String scope) {
        return Flux.fromIterable((Iterable)this.scopes.getOrDefault(ConfigScope.of(scope, scope, false), Collections.emptySet()));
    }

    @Override
    public Mono<ValueObject> getProperties(String scope) {
        return Mono.zip((Mono)this.getPropertyDef(scope).filter(def -> null != def.getDefaultValue()).collectMap(ConfigPropertyDef::getKey, ConfigPropertyDef::getDefaultValue), (Mono)((ReactiveQuery)this.repository.createQuery().where(ConfigEntity::getScope, (Object)scope)).fetch().filter(val -> MapUtils.isNotEmpty(val.getProperties())).reduce(new LinkedHashMap(), (l, r) -> {
            l.putAll(r.getProperties());
            return l;
        }), (defaults, values) -> {
            defaults.forEach(values::putIfAbsent);
            return values;
        }).map(ValueObject::of);
    }

    @Override
    public Mono<Void> setProperties(String scope, Map<String, Object> values) {
        return ((Mono)Flux.fromIterable(values.entrySet()).map(e -> {
            ConfigEntity entity = new ConfigEntity();
            entity.setProperties(values);
            entity.setScope(scope);
            entity.getId();
            return entity;
        }).as(arg_0 -> this.repository.save(arg_0))).then();
    }

    public SimpleConfigManager(ReactiveRepository<ConfigEntity, String> repository) {
        this.repository = repository;
    }
}

