/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.GenericTreeSortSupportEntity;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.crud.service.ReactiveTreeSortEntityService;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.system.authorization.api.event.ClearUserAuthorizationCacheEvent;
import org.jetlinks.community.auth.entity.MenuBindEntity;
import org.jetlinks.community.auth.entity.MenuEntity;
import org.jetlinks.community.auth.entity.MenuView;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class DefaultMenuService
extends GenericReactiveCrudService<MenuEntity, String>
implements ReactiveTreeSortEntityService<MenuEntity, String> {
    private final ReactiveRepository<MenuBindEntity, String> bindRepository;
    private final ApplicationEventPublisher eventPublisher;

    public DefaultMenuService(ReactiveRepository<MenuBindEntity, String> bindRepository, ApplicationEventPublisher eventPublisher) {
        this.bindRepository = bindRepository;
        this.eventPublisher = eventPublisher;
    }

    @Generated
    public IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    @Generated
    public void setChildren(MenuEntity menuEntity, List<MenuEntity> children) {
        menuEntity.setChildren(children);
    }

    @Generated
    public List<MenuEntity> getChildren(MenuEntity menuEntity) {
        return menuEntity.getChildren();
    }

    public Flux<MenuView> getMenuViews(QueryParamEntity queryParam, Predicate<MenuEntity> menuPredicate) {
        return ((ReactiveQuery)((ReactiveQuery)this.createQuery().setParam((QueryParam)queryParam.noPaging())).orderBy(new SortOrder[]{SortOrder.asc(GenericTreeSortSupportEntity::getSortIndex)})).fetch().collectMap(GenericEntity::getId, Function.identity()).flatMapIterable(menus -> this.convertMenuView((Map<String, MenuEntity>)menus, menuPredicate, MenuView::of));
    }

    public Mono<Integer> countMenuBy(String code, String owner) {
        return ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.createQuery().where(MenuEntity::getCode, (Object)code)).and(MenuEntity::getOwner, (Object)owner)).orderBy(new SortOrder[]{SortOrder.asc(GenericTreeSortSupportEntity::getSortIndex)})).count();
    }

    public Flux<MenuView> getGrantedMenus(QueryParamEntity queryParam, List<Dimension> dimensions) {
        if (CollectionUtils.isEmpty(dimensions)) {
            return Flux.empty();
        }
        List keyList = dimensions.stream().map(dimension -> MenuBindEntity.generateTargetKey(dimension.getType().getId(), dimension.getId())).collect(Collectors.toList());
        return (Flux)((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.bindRepository.createQuery().setParam((QueryParam)queryParam.noPaging())).where()).in(MenuBindEntity::getTargetKey, keyList)).fetch().as(this::convertToView);
    }

    public Flux<MenuView> getGrantedMenus(String dimensionType, String dimensionId) {
        return this.getGrantedMenus(dimensionType, Collections.singleton(dimensionId));
    }

    public Flux<MenuView> getGrantedMenus(String dimensionType, Collection<String> dimensionIds) {
        return (Flux)((ReactiveQuery)((ReactiveQuery)this.bindRepository.createQuery().where()).in(MenuBindEntity::getTargetKey, (Collection)dimensionIds.stream().map(dimensionId -> MenuBindEntity.generateTargetKey(dimensionType, dimensionId)).collect(Collectors.toSet()))).fetch().as(this::convertToView);
    }

    private Flux<MenuView> convertToView(Flux<MenuBindEntity> entityFlux) {
        return Mono.zip((Mono)((ReactiveQuery)((ReactiveQuery)this.createQuery().where()).and(MenuEntity::getStatus, (Object)1)).fetch().collectMap(GenericEntity::getId, Function.identity(), LinkedHashMap::new), (Mono)entityFlux.collect(Collectors.groupingBy(MenuBindEntity::getMenuId)), (menus, binds) -> this.convertMenuView((Map<String, MenuEntity>)menus, menu -> binds.get(menu.getId()) != null, menu -> MenuView.of(menu, (List)binds.get(menu.getId())))).flatMapIterable(Function.identity());
    }

    public Collection<MenuView> convertMenuView(Map<String, MenuEntity> menuMap, Predicate<MenuEntity> menuPredicate, Function<MenuEntity, MenuView> converter) {
        HashMap<Object, MenuEntity> group = new HashMap<Object, MenuEntity>();
        for (MenuEntity menu : menuMap.values()) {
            MenuEntity parent;
            if (group.containsKey(menu.getId()) || !menuPredicate.test(menu)) continue;
            String parentId = (String)menu.getParentId();
            group.put(menu.getId(), menu);
            while (StringUtils.hasText((String)parentId) && (parent = menuMap.get(parentId)) != null) {
                parentId = (String)parent.getParentId();
                group.put(parent.getId(), parent);
            }
        }
        return group.values().stream().map(converter).sorted().collect(Collectors.toList());
    }

    @EventListener
    public void handleMenuEntity(EntityModifyEvent<MenuEntity> e) {
        e.async((Publisher)ClearUserAuthorizationCacheEvent.all().publish(this.eventPublisher));
    }

    @EventListener
    public void handleMenuEntity(EntityDeletedEvent<MenuEntity> e) {
        e.async((Publisher)ClearUserAuthorizationCacheEvent.all().publish(this.eventPublisher));
    }

    @EventListener
    public void handleMenuEntity(EntitySavedEvent<MenuEntity> e) {
        e.async((Publisher)ClearUserAuthorizationCacheEvent.all().publish(this.eventPublisher));
    }
}

