/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import javax.persistence.Column;
import javax.persistence.Table;
import org.hibernate.validator.constraints.Length;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.authorization.DefaultDimensionType;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.DimensionType;
import org.hswebframework.web.authorization.simple.SimpleDimension;
import org.jetlinks.community.auth.enums.RoleState;

@Table(name="s_role")
@Comment(value="\u89d2\u8272\u4fe1\u606f\u8868")
public class RoleEntity
extends GenericEntity<String>
implements RecordCreationEntity {
    @Column(length=64)
    @Length(min=1, max=64)
    @Schema(description="\u540d\u79f0")
    private @Length(min=1, max=64) String name;
    @Column
    @Length(max=255)
    @Schema(description="\u8bf4\u660e")
    private @Length(max=255) String description;
    @Column(length=32)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @Schema(description="\u72b6\u6001\u3002enabled\u4e3a\u6b63\u5e38\uff0cdisabled\u4e3a\u5df2\u7981\u7528")
    @DefaultValue(value="enabled")
    private RoleState state;
    @Column(updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private String creatorId;
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4", accessMode=Schema.AccessMode.READ_ONLY)
    private Long createTime;

    public Dimension toDimension() {
        SimpleDimension dimension = new SimpleDimension();
        dimension.setId((String)this.getId());
        dimension.setName(this.name);
        dimension.setType((DimensionType)DefaultDimensionType.role);
        return dimension;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public RoleState getState() {
        return this.state;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setState(RoleState state) {
        this.state = state;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }
}

