import { MESSAGE_SUBSCRIBE_MENU_DATA } from '@/views/init-home/data/baseMenu'


/**
 * 属性图标
 */
export const PROPERTY_ICON = {
    'temperature': '/device-overview/kqjc/WD@2x.png',
    'humidity': '/device-overview/kqjc/SD@2x.png',
    'tvoc': '/device-overview/kqjc/tvoc@2x.png',
    'hcho': '/device-overview/kqjc/JQ@2x.png',
    'noise': '/device-overview/kqjc/O3@2x.png',
    'light': '/device-overview/kqjc/SF6@2x.png',
    'co': '/device-overview/kqjc/O2@2x.png',
    'pm10': '/device-overview/kqjc/PM10@2x.png',
    'pm2.5': '/device-overview/kqjc/PM2.5@2x.png',    
    'smoke': '/device-overview/kqjc/SF6@2x.png',
    'h2s': '/device-overview/kqjc/SF6@2x.png',
    'ch4': '/device-overview/kqjc/SF6@2x.png',
    'co2': '/device-overview/kqjc/NO2@2x.png'
}

/**
 * 状态颜色
 */
export const STATE_COLOR = {
    /** 已停止 */
    'disabled': '#EB5757',
    /** 已启用 */
    'enabled': '#00CCA5',
    /** 禁用 */
    'notActive': '#F2994A',
    // 运行中
    'running': '#00CCA5',
    // 部分错误
    'partialError': '#EB5757',
    // 错误
    'failed': '#F2994A',
    // 已停止
    'stopped': '#F2994A'
}

/**
 * 卡片组件状态
 */
export const StatusColorEnum = {
  'success': 'success',
  'error': 'error',
  'processing': 'processing',
  'warning': 'warning',
  'default': 'default',
}

export const SystemConst = {
  API_BASE: 'api',
  SYSTEM_NAME: '欢迎来到档案库房监控一体化系统',
  LOGIN: 'LOGIN-STATUS',
  DOC_URL: 'http://doc.xxxxxxx.cn',
  BASE_CURD_MODAL_VISIBLE: 'BASE_CURD_MODAL_VISIBLE',
  BASE_CURD_CURRENT: 'BASE_CURD_CURRENT',
  BASE_CURD_MODEL: 'BASE_CURD_MODEL',
  BASE_UPDATE_DATA: 'BASE_UPDATE_DATA',
  GLOBAL_WEBSOCKET: 'GLOBAL-WEBSOCKET',
  BIND_USER_STATE: 'false',
  REFRESH_METADATA: 'refresh_metadata',
  REFRESH_METADATA_TABLE: 'refresh_metadata_table',
  GET_METADATA: 'get_metadata',
  REFRESH_DEVICE: 'refresh_device',
  VERSION_CODE: 'version_code',
  AMAP_KEY : 'amap_key',
}

export const USER_CENTER_MENU_CODE = 'account-center'
export const USER_CENTER_MENU_BUTTON_CODE = 'user-center-passwd-update'
export const MESSAGE_SUBSCRIBE_MENU_CODE = 'message-subscribe'
export const MESSAGE_SUBSCRIBE_MENU_BUTTON_CODE = 'message-subscribe-view'
