
import axios from 'axios'
import { notification as Notification } from 'jetlinks-ui-components'

/**
 * 密集框操控接口
 */

const showNotification = (message: string, description: string, key?: string, show: boolean = true) => {
    if (show) {
      Notification.error({
        key,
        message,
        description
      })
    }
  }

  //密集架操作
export const mjjOper = async (serverAddr:string,opType: string) => {
    if(1==1){
        return true;
    }
    let rNum = Math.floor(Math.random() * 10000);
    const res = await axios({
        method: "get",
        url:
          "http://" +
          serverAddr +
          "/MjjService?Op=" +opType +
          "&r=" + rNum,
        responseType: "json",
        timeout: 1000 * 15
      }).catch(err => {
        console.log(err);
        showNotification(err, '密集架响应超时', undefined)
      });
      console.log("======mjjOper==========",res)
      if (res) {
        if( res.data == "1"){
            return true;         
        }else{
            showNotification('密集架操作失败',res.data, '400')
        } 
      }  
      return false;
}


export const  mjjMove = async (serverAddr:string,columnNo:string,step:number) => {

    if(1==1){
        return true;
    }

    let op = '';
    if(step==-1){
        op = 'LeftMove'
    }else if(step==1){
        op = 'RightMove'
    }
    let rNum = Math.floor(Math.random() * 10000);
    const res = await axios({
        method: "get",
        url:
          "http://" +
          serverAddr +
          "/MjjService?Op=" +op+
          "&ColumnNo=" +
          columnNo +
          "&r=" +
          rNum,
        responseType: "json",
        timeout: 1000 * 5
      }).catch(err => {
        console.log(err);
        showNotification('密集接口响应超时', err,undefined);
      });
        
      if (res) {
        if( res.data == "1"){
            return true;         
        }else{
            showNotification( '密集架移动操作失败', res.data,undefined);
        } 
      }  
      return false;
}



export const getMjjStatus =async (serverAddr:string) =>  {

    if(1==1){
        const r = [{"QUNO":"1","Temp":"28.0","Hum":"32.0","PM2_5":"0.0","PM10":"0.0","TVOC":"0.0","CO2":"0.0","COLNO":"2","MJJZTLX":"ZT_17","MJJZTLXName":"关电源(列:2)","COLUMNDWZT":"","COLUMNDWZT_CHANGED":"0","DATA":"","IsBJ":"1","IsLock":"1","IsVent":"0","IsPower":"0","IsZDKJ":"0","ColumnStatus":"02","IsPause":"1","TxStatus":"正常"}];
        return r[0];
    }
    const res = await axios({
      method: "get",
      url: "http://" + serverAddr + "/MjjService?Op=GetMjjStatus",
      responseType: "json"
    })
    .catch(err => {
        console.log(err);
        showNotification(err, '密集接口响应超时', undefined)
    });   
    if (res) {
      if(res.data.Error){
        showNotification(res.data.Error, '密集架状态查询出错', undefined)
      }else{
        if(res.data.length==0){
            showNotification('密集架状态查询出错','返回状态数据为空', undefined)
        }else{
            return {...res.data[0],TxStatus:'正常'};
        }        
      } 
    }  
    //showNotification( '密集架状态查询出错',"无返回信息", undefined)    
    return {TxStatus: '连接失败'};
  }


  export const getMjjQuXX =async (serverAddr:string) =>  {    
     const r = [{"QuNo":"1","ColCn":"5","GDLNo":"2","LeCn":"2","DivCn":"5","ColNoRule":"1","FirstColNo":"1"}];
     if(1==1){        
        return r[0];
     }
     const res = await axios({
        method: "get",
        url: "http://" + serverAddr + "/MjjService?Op=GetQuXX",
        responseType: "json"
      })
      .catch(err => {
          console.log(err);
          showNotification('密集接口响应超时',err, undefined)
      });   
      if (res) {
        if(res.data.Error){
          showNotification( '密集架查询区域信息出错',res.data.Error, undefined)
        }else{
          if(res.data.length==0){
              showNotification('密集架查询区域信息出错','返回状态数据为空', undefined)
          }else{
              return res.data[0];
          }        
        } 
      }  
      showNotification( '密集架查询区域信息出错',"无返回信息", undefined)
      return null;
  }
  

  
