// 密集架
import server from '@/utils/request'
import { MonitoringDeviceItem } from '@/views/monitoring/device/typings'
/**
 * 查询
 */
export const queryMD = (params?: Record<string, any>) => server.post<any>('/aw/monitoring/device/_query', params)
export const queryMDInfo = (params?: Record<string, any>) => server.post<MonitoringDeviceItem>('/aw/monitoring/device/info/_query', params)

export const queryDeviceTree = (params?: Record<string, any>) => server.get<any>('/aw/monitoring/device/_tree', params)

/**
 * 保存树形数据
 */
 export const saveMD = (data: any) =>server.post('/aw/monitoring/device', data)
 
 /**
  * 根据Id修改
  */
 export const updateMD = (id:string,data: any,) => server.put(`/aw/monitoring/device/${id}`, data)

 /**
  * 根据Id删除数据
  */
 export const deleteMD = (id:string) => server.remove(`/aw/monitoring/device/${id}`)