/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.portal.params.TemplateToMenuVo;
import com.artfess.sysConfig.persistence.manager.SysMenuManager;
import com.artfess.sysConfig.persistence.manager.SysMethodManager;
import com.artfess.sysConfig.persistence.model.SysMenu;
import com.artfess.sysConfig.persistence.model.SysMethod;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/sys/sysMenu/v1"})
@Api(tags={"\u7cfb\u7edf\u83dc\u5355"})
@ApiGroup(group={"group_system"})
public class SysMenuController
extends BaseController<SysMenuManager, SysMenu> {
    @Resource
    SysMenuManager sysMenuManager;
    @Resource
    SysMethodManager sysMethodManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u8d44\u6e90\u6570\u636e", httpMethod="POST", notes="\u83dc\u5355\u8d44\u6e90\u6570\u636e")
    public PageList<SysMenu> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysMenu> queryFilter) throws Exception {
        return this.sysMenuManager.query(queryFilter);
    }

    @RequestMapping(value={"getTree"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u6811\u5f62\u83dc\u5355", httpMethod="GET", notes="\u83b7\u5f97\u6811\u5f62\u83dc\u5355")
    public List<SysMenu> getTree(@ApiParam(name="ignoreAlias", value="\u5ffd\u7565\u83dc\u5355\uff08\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00\uff09", required=true) @RequestParam Optional<String> ignoreAlias) throws Exception {
        List list = this.sysMenuManager.getAllByTenant(ignoreAlias.orElse(""), null);
        list = BeanUtils.listToTree((List)list);
        return list;
    }

    @RequestMapping(value={"saveMenus"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8d44\u6e90\u83dc\u5355", httpMethod="POST", notes="\u4fdd\u5b58\u8d44\u6e90\u83dc\u5355")
    public CommonResult<String> saveMenus(@ApiParam(name="list", value="\u83dc\u5355\u5217\u8868") @RequestBody List<SysMenu> list) throws Exception {
        List oldList = this.sysMenuManager.list();
        HashMap<String, SysMenu> oldMap = new HashMap<String, SysMenu>();
        for (SysMenu sysMenu : oldList) {
            oldMap.put(sysMenu.getId(), sysMenu);
        }
        ArrayList<SysMenu> changeMenus = new ArrayList<SysMenu>();
        for (SysMenu menu : list) {
            if (menu.equals((SysMenu)oldMap.get(menu.getId()))) continue;
            changeMenus.add(menu);
        }
        for (SysMenu sysMenu : changeMenus) {
            this.sysMenuManager.update((Model)sysMenu);
        }
        ((SysMenuManager)this.baseService).delUserMenuCache();
        return new CommonResult("\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"getMenuByRoleAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u89d2\u8272\u6811\u5f62\u83dc\u5355", httpMethod="GET", notes="\u83b7\u5f97\u89d2\u8272\u6811\u5f62\u83dc\u5355")
    public List<SysMenu> getMenuByRoleAlias(@ApiParam(name="roleAlias", value="\u89d2\u8272\u522b\u540d", required=true) @RequestParam String roleAlias) throws Exception {
        return this.sysMenuManager.getMenuByRoleAlias(roleAlias);
    }

    @RequestMapping(value={"getAllMenuRoleAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u5f97\u89d2\u8272\u6811\u5f62\u83dc\u5355", httpMethod="GET", notes="\u83b7\u5f97\u89d2\u8272\u6811\u5f62\u83dc\u5355")
    public ArrayList<Map<String, Object>> getAllMenuRoleAlias(@ApiParam(name="roleAlias", value="\u89d2\u8272\u522b\u540d", required=true) @RequestParam String roleAlias) throws Exception {
        return (ArrayList)this.sysMenuManager.getAllMenuRoleAlias(roleAlias, null);
    }

    @RequestMapping(value={"getAllMethodByRoleAlias"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u7684\u540e\u53f0\u65b9\u6cd5", httpMethod="POST", notes="\u83b7\u53d6\u6388\u6743\u7684\u540e\u53f0\u65b9\u6cd5")
    public ArrayList<Map<String, Object>> getAllMethodByRoleAlias(@ApiParam(name="roleAlias", value="\u89d2\u8272\u522b\u540d", required=true) @RequestParam String roleAlias) throws Exception {
        return (ArrayList)this.sysMethodManager.getAllMethodByRoleAlias(roleAlias);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u8d44\u6e90\u6570\u636e\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u83dc\u5355\u8d44\u6e90\u6570\u636e\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysMenu getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        SysMenu sysMenu = new SysMenu();
        sysMenu.setOpen(true);
        if (!StringUtil.isEmpty((String)id)) {
            try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                sysMenu = (SysMenu)this.sysMenuManager.get((Serializable)((Object)id));
            }
        }
        return sysMenu;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u83dc\u5355\u8d44\u6e90\u6570\u636e\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u83dc\u5355\u8d44\u6e90\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysMenu", value="\u83dc\u5355\u8d44\u6e90", required=true) @RequestBody SysMenu sysMenu) throws Exception {
        String resultMsg = null;
        String id = sysMenu.getId();
        if (StringUtil.isEmpty((String)id)) {
            if (this.sysMenuManager.isExistByAlias(sysMenu.getAlias())) {
                throw new BaseException("\u83dc\u5355\u522b\u540d\u5df2\u5b58\u5728");
            }
            List sysMethods = sysMenu.getSysMethods();
            for (int i = 0; i < sysMethods.size() - 1; ++i) {
                for (int j = i + 1; j < sysMethods.size(); ++j) {
                    if (!((SysMethod)sysMethods.get(i)).getAlias().equals(((SysMethod)sysMethods.get(j)).getAlias())) continue;
                    return new CommonResult(false, "\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u91cd\u590d");
                }
            }
            sysMenu.setId(UniqueIdUtil.getSuid());
            sysMenu.setPath(sysMenu.getPath() + sysMenu.getId() + ".");
            if (BeanUtils.isEmpty((Object)sysMenu.getSn())) {
                sysMenu.setSn(99);
            }
            this.sysMenuManager.create((Model)sysMenu);
            resultMsg = "\u6dfb\u52a0\u83dc\u5355\u4fe1\u606f\u6210\u529f";
        } else {
            List sysMethods = sysMenu.getSysMethods();
            for (int i = 0; i < sysMethods.size() - 1; ++i) {
                for (int j = i + 1; j < sysMethods.size(); ++j) {
                    if (!((SysMethod)sysMethods.get(i)).getAlias().equals(((SysMethod)sysMethods.get(j)).getAlias())) continue;
                    return new CommonResult(false, "\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u91cd\u590d");
                }
            }
            this.sysMenuManager.update((Model)sysMenu);
            resultMsg = "\u66f4\u65b0\u83dc\u5355\u4fe1\u606f\u6210\u529f";
        }
        ((SysMenuManager)this.baseService).delUserMenuCache();
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"saveBatch"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u83dc\u5355\u8d44\u6e90\u6570\u636e\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u83dc\u5355\u8d44\u6e90\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> saveBatch(@ApiParam(name="list", value="\u83dc\u5355\u8d44\u6e90", required=true) @RequestBody List<SysMenu> list) throws Exception {
        String resultMsg = "";
        for (int k = 0; k < list.size(); ++k) {
            List sysMethods = list.get(k).getSysMethods();
            for (int i = 0; i < sysMethods.size() - 1; ++i) {
                for (int j = i + 1; j < sysMethods.size(); ++j) {
                    if (!((SysMethod)sysMethods.get(i)).getAlias().equals(((SysMethod)sysMethods.get(j)).getAlias())) continue;
                    return new CommonResult(false, "\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u91cd\u590d");
                }
            }
            this.sysMenuManager.update((Model)list.get(k));
        }
        resultMsg = "\u66f4\u65b0\u83dc\u5355\u4fe1\u606f\u6210\u529f";
        ((SysMenuManager)this.baseService).delUserMenuCache();
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u83dc\u5355\u4fe1\u606f\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u83dc\u5355\u4fe1\u606f\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        this.sysMenuManager.removeByResId(id);
        return new CommonResult(true, "\u5220\u9664\u83dc\u5355\u4fe1\u606f\u6210\u529f");
    }

    @RequestMapping(value={"isMenuExistByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u6d4b\u83dc\u5355\u8d44\u6e90\u522b\u540d\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="GET", notes="\u68c0\u6d4b\u83dc\u5355\u8d44\u6e90\u522b\u540d\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    @ResponseBody
    public CommonResult<Boolean> isMenuExistByAlias(@ApiParam(name="alias", value="\u83dc\u5355\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        boolean existByAlias = this.sysMenuManager.isExistByAlias(alias);
        CommonResult commonResult = new CommonResult();
        commonResult.setValue((Object)existByAlias);
        return commonResult;
    }

    @RequestMapping(value={"isMethodExistByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u6d4b\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="GET", notes="\u68c0\u6d4b\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    @ResponseBody
    public CommonResult<Boolean> isMethodExistByAlias(@ApiParam(name="alias", value="\u83dc\u5355\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        boolean existByAlias = this.sysMethodManager.isExistByAlias(alias);
        CommonResult commonResult = new CommonResult();
        commonResult.setValue((Object)existByAlias);
        return commonResult;
    }

    @RequestMapping(value={"getCurrentUserMenu"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u83dc\u5355")
    @ResponseBody
    public CommonResult<List<SysMenu>> getCurrentUserMenu(@ApiParam(name="menuAlias", value="\u83dc\u5355\u7c7b\u578b", required=true) @RequestParam String menuAlias) throws Exception {
        CommonResult commonResult = new CommonResult(true, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u83dc\u5355\u4fe1\u606f");
        List<SysMenu> lists = this.sysMenuManager.getCurrentUserMenu();
        lists = this.i18nSysMenu(lists);
        List result = this.sysMenuManager.filterByMenuAlias(menuAlias, lists);
        commonResult.setValue((Object)result);
        return commonResult;
    }

    private List<SysMenu> i18nSysMenu(List<SysMenu> lists) {
        ArrayList<String> i18nKey = new ArrayList<String>();
        for (SysMenu sysMenu : lists) {
            i18nKey.add(sysMenu.getAlias());
        }
        Map messages = I18nUtil.getMessages(i18nKey, (Locale)LocaleContextHolder.getLocale());
        for (SysMenu sysMenu : lists) {
            String key = sysMenu.getAlias();
            if (!messages.containsKey(key) || !StringUtil.isNotEmpty((String)((String)messages.get(key))) || key.equals(messages.get(key))) continue;
            sysMenu.setName((String)messages.get(key));
        }
        return lists;
    }

    @RequestMapping(value={"getCurrentUserMethodAuth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u8bf7\u6c42\u6743\u9650", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u8bf7\u6c42\u6743\u9650")
    @ResponseBody
    public Map<String, List<String>> getCurrentUserMethodAuth() throws Exception {
        List all = this.sysMethodManager.list();
        ArrayList<String> sysMethodList = new ArrayList<String>();
        for (SysMethod sysMethod : all) {
            sysMethodList.add(sysMethod.getAlias());
        }
        IUser currentUser = ContextUtil.getCurrentUser();
        List<String> curUserMethod = sysMethodList;
        if (!currentUser.isAdmin()) {
            curUserMethod = this.sysMethodManager.getCurrentUserMethodAuth();
        }
        HashMap<String, List<String>> rtnMap = new HashMap<String, List<String>>();
        rtnMap.put("allMethod", sysMethodList);
        rtnMap.put("curUserMethod", curUserMethod);
        return rtnMap;
    }

    @RequestMapping(value={"addDataTemplateToMenu"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5230\u83dc\u5355", httpMethod="POST", notes="\u6dfb\u52a0\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5230\u83dc\u5355")
    public CommonResult<String> addDataTemplateToMenu(@ApiParam(name="templateToMenuVo", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6dfb\u52a0\u5230\u83dc\u5355\u53c2\u6570", required=true) @RequestBody TemplateToMenuVo templateToMenuVo) throws Exception {
        if (StringUtil.isEmpty((String)templateToMenuVo.getParentAlias())) {
            return new CommonResult(false, "\u7236\u83dc\u5355\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)templateToMenuVo.getAlias())) {
            return new CommonResult(false, "\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysMenu pMenu = this.sysMenuManager.getByAlias(templateToMenuVo.getParentAlias());
        if (BeanUtils.isEmpty((Object)pMenu)) {
            return new CommonResult(false, "\u6839\u636e\u7236\u83dc\u5355\u522b\u540d" + templateToMenuVo.getParentAlias() + "\u672a\u627e\u5230\u5bf9\u5e94\u83dc\u5355\uff01");
        }
        boolean isExist = this.sysMenuManager.isExistByAlias(templateToMenuVo.getAlias());
        if (isExist) {
            return new CommonResult(false, "\u522b\u540d\u3010" + templateToMenuVo.getAlias() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        SysMenu templateListMenu = new SysMenu();
        try {
            String id = UniqueIdUtil.getSuid();
            templateListMenu.setPath(pMenu.getPath() + id + ".");
            templateListMenu.setSn(99);
            templateListMenu.setOpen(false);
            templateListMenu.setHref(templateToMenuVo.getHref());
            templateListMenu.setAlias(templateToMenuVo.getAlias());
            templateListMenu.setName(templateToMenuVo.getName());
            templateListMenu.setActiveTab(templateToMenuVo.getPath());
            templateListMenu.setId(id);
            templateListMenu.setParentId(pMenu.getId());
            this.sysMenuManager.create((Model)templateListMenu);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f\uff0c\u91cd\u65b0\u767b\u5f55\u540e\u751f\u6548\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u5bfc\u5165", httpMethod="POST", notes="\u83dc\u5355\u5bfc\u5165")
    public CommonResult<String> importData(MultipartHttpServletRequest request, @ApiParam(name="parentMenuId", value="\u7236\u83dc\u5355ID", required=true) @RequestParam String parentMenuId) throws Exception {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            this.sysMenuManager.importFile(unZipFilePath, parentMenuId);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83dc\u5355\u5bfc\u51fa", httpMethod="GET", notes="\u83dc\u5355\u5bfc\u51fa")
    public void export(@ApiParam(name="parentMenuId", value="\u7236\u83dc\u5355ID") @RequestParam String parentMenuId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SysMenu menu = (SysMenu)this.sysMenuManager.get((Serializable)((Object)parentMenuId));
        if (!BeanUtils.isNotEmpty((Object)menu)) {
            throw new RuntimeException("\u5bfc\u51fa\u7684\u83dc\u5355\u4e0d\u5b58\u5728\uff01");
        }
        List childrenMenus = this.sysMenuManager.getByChidrensParentPath(menu.getPath());
        String json = JsonUtil.toJson((Object)childrenMenus);
        HashMap<String, String> fileContentMap = new HashMap<String, String>();
        fileContentMap.put("sysMenus.json", json);
        fileContentMap.put("parentMenu.json", JsonUtil.toJson((Object)menu));
        String fileName = "sysMenus_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, fileContentMap, (String)fileName);
    }

    @RequestMapping(value={"getThreeAdminMenu"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e09\u5458\u83dc\u5355", httpMethod="GET", notes="\u83b7\u53d6\u4e09\u5458\u83dc\u5355")
    @ResponseBody
    public CommonResult<Map<String, List<SysMenu>>> getThreeAdminMenu(@ApiParam(name="tenantId", value="\u79df\u6237ID", required=true) @RequestParam String tenantId) throws Exception {
        CommonResult commonResult = new CommonResult(true, "\u83b7\u53d6\u4e09\u5458\u83dc\u5355");
        Map map = this.sysMenuManager.getThreeAdminMenu(tenantId);
        commonResult.setValue((Object)map);
        return commonResult;
    }
}

