"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var base_1 = require("../base");
var get_style_1 = require("../util/get-style");
(0, base_1.registerShape)('point', 'image', {
    draw: function (cfg, container) {
        var size = (0, get_style_1.getStyle)(cfg, false, false, 'r').r;
        var points = this.parsePoints(cfg.points);
        var pointPosition = points[0];
        if (cfg.isStack) {
            pointPosition = points[1];
        }
        else if (points.length > 1) {
            var group = container.addGroup();
            for (var _i = 0, points_1 = points; _i < points_1.length; _i++) {
                var point = points_1[_i];
                group.addShape('image', {
                    attrs: {
                        x: point.x - size / 2,
                        y: point.y - size,
                        width: size,
                        height: size,
                        img: cfg.shape[1],
                    },
                });
            }
            return group;
        }
        return container.addShape('image', {
            attrs: {
                x: pointPosition.x - size / 2,
                y: pointPosition.y - size,
                width: size,
                height: size,
                img: cfg.shape[1],
            },
        });
    },
    getMarker: function (markerCfg) {
        var color = markerCfg.color;
        return {
            symbol: 'circle',
            style: {
                r: 4.5,
                fill: color,
            },
        };
    },
});
//# sourceMappingURL=image.js.map