import { __extends } from "tslib";
import ListState from './list-state';
var STATUS_UNCHECKED = 'unchecked';
var ListFocus = /** @class */ (function (_super) {
    __extends(ListFocus, _super);
    function ListFocus() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ListFocus.prototype.toggle = function () {
        var triggerInfo = this.getTriggerListInfo();
        if (triggerInfo === null || triggerInfo === void 0 ? void 0 : triggerInfo.item) {
            var list_1 = triggerInfo.list, clickedItem = triggerInfo.item;
            var items = list_1.getItems();
            var checkedItems = items.filter(function (t) { return !list_1.hasState(t, STATUS_UNCHECKED); });
            var uncheckedItems = items.filter(function (t) { return list_1.hasState(t, STATUS_UNCHECKED); });
            var checkedItem = checkedItems[0];
            /**
             * 1. 初始化，全部 checked。此时，点击 radio, clickItem 进入聚焦
             * 2. 当前只选中一个
             *    2.1 且选中 item 等于 clickItem，退出聚焦，全部重新选中
             *    2.2 替换聚焦的 item
             * 3. 其它，同 2.2
             */
            if (items.length === checkedItems.length) {
                for (var _i = 0, items_1 = items; _i < items_1.length; _i++) {
                    var item = items_1[_i];
                    list_1.setItemState(item, STATUS_UNCHECKED, item.id !== clickedItem.id);
                }
            }
            else if (items.length - uncheckedItems.length === 1) {
                if (checkedItem.id === clickedItem.id) {
                    for (var _a = 0, items_2 = items; _a < items_2.length; _a++) {
                        var item = items_2[_a];
                        list_1.setItemState(item, STATUS_UNCHECKED, false);
                    }
                }
                else {
                    for (var _b = 0, items_3 = items; _b < items_3.length; _b++) {
                        var item = items_3[_b];
                        list_1.setItemState(item, STATUS_UNCHECKED, item.id !== clickedItem.id);
                    }
                }
            }
            else {
                for (var _c = 0, items_4 = items; _c < items_4.length; _c++) {
                    var item = items_4[_c];
                    list_1.setItemState(item, STATUS_UNCHECKED, item.id !== clickedItem.id);
                }
            }
        }
    };
    return ListFocus;
}(ListState));
export default ListFocus;
//# sourceMappingURL=list-focus.js.map