import { getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '订单总金额(万元)',
            prop: 'totalAmount',
            type: 'input',
            value: ''
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'companyName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '法定代表人',
            prop: 'companyEbe',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '供应商状态',
            prop: 'type',
            type: 'select',
            multiple: true,
            options: getDictionaryByCode('hggys-zt'),
            value: [],
            span: 4
        },
        {
            title: '准入时间',
            prop: 'applyDate',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '供方名称',
            prop: 'companyName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '法定代表人',
            prop: 'companyEbe',
            minWidth: 120,
            sortable: true
        },
        {
            title: '订单总金额(万元)',
            prop: 'totalAmount',
            minWidth: 120,
            sortable: true
        },
        {
            title: '供应商等级',
            prop: 'gradingName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '供应商类型',
            prop: 'catName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '供应商状态',
            prop: 'type',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '准入时间',
            prop: 'applyDate',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
