package com.artfess.report.bigScreen.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.report.bigScreen.model.BladeVisual;
import com.artfess.report.bigScreen.model.BladeVisualCategory;
import com.artfess.report.bigScreen.vo.BladeVisualConfigVo;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 可视化表 服务类
 *
 * @company 阿特菲斯
 * @author 向贞好
 * @since 2021-07-12
 */
public interface BladeVisualManager extends BaseManager<BladeVisual> {

    PageList<BladeVisual> queryBladeVisual(QueryFilter<BladeVisual> queryFilter);

    String uploadPhoto(MultipartFile positiveFile) throws Exception;

    /**
     * 根据id获取大屏数据和配置信息
     * @param id
     * @return
     */
    BladeVisualConfigVo getVisualConfig(String id);

    /**
     * 新增数据
     * @param bladeVisualConfigVo
     * @return
     */
    String saveBladeVisualConfigVo(BladeVisualConfigVo bladeVisualConfigVo);

    void updateBladeVisualConfigVo(BladeVisualConfigVo bladeVisualConfigVo);


}
