package com.artfess.easyExcel.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.artfess.easyExcel.annotaion.ExcelDictItem;
import com.artfess.easyExcel.annotaion.ExcelDictItemLabel;
import com.artfess.easyExcel.converter.DelStatusConverter;
import com.artfess.easyExcel.converter.ExcelDictConverter;
import com.artfess.easyExcel.converter.LocalDateConverter;
import com.artfess.easyExcel.service.impl.DictNameServiceImpl;
import com.artfess.easyExcel.annotaion.ExcelImportHeader;
import com.artfess.easyExcel.annotaion.ExcelSelected;
import lombok.Data;

import java.time.LocalDate;

/**
 * 示例
 */
@Data
@ExcelIgnoreUnannotated //这个注解的意思是：忽略不加@ExcelProperty的字段进行导出
public class UserVo {

    @ExcelProperty(value = "姓名")
    private String name;

    @ExcelProperty(value = "年龄")
    private int age;

    @ExcelProperty(value = "出生日期", converter = LocalDateConverter.class)
    private LocalDate birthdate;

    @ExcelSelected(source = {"否","是"})
    @ExcelProperty(value = "是否删除", converter = DelStatusConverter.class) @ExcelImportHeader
    private String delStatus;

    /**
     * 字典转换器
     */
    @ExcelProperty(value = "性别", converter = ExcelDictConverter.class)
    //导出excel时根据字典获取对应下拉值
    @ExcelSelected(sourceClass = DictNameServiceImpl.class, dictKey = "gender")
    @ExcelDictItemLabel(type = "gender")
    @ExcelDictItem(type = "gender")
    private String sex;
}
