import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierAccessConfiguration/v1/queryPage`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格新增
export function dataAdd(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierAccessConfiguration/v1/saveModel`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格修改
export function dataUpdate(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierAccessConfiguration/v1/updateModel`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格回显
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierAccessConfiguration/v1/getInfo/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格删除
export function dataDelete(ids: string) {
    return new Promise((resolve, reject) => {
        request
            .delete(`/bizSupplierAccessConfiguration/v1/?ids=${ids}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 物资分类列表接口
export function materialDataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizCategory/v1/query`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 资质分类列表接口
export function aptitudeDataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierQualificationCategory/v1/query`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 物资分类
export function materialCategoryList(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizCategory/v1/tree`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格修改状态
export function dataStatus(id: string, status: string) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierAccessConfiguration/v1/updateStatus?id=${id}&status=${status}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
