;(function (window, document) {
    function title() {
        const ajax = new XMLHttpRequest()
        const url = window.config.API_BASE_URL + '/uc/tenantManage/v1/getTenantByCode?code=platform'
        ajax.open('get', url)
        //步骤三:发送请求
        ajax.send()
        //步骤四:注册事件 onreadystatechange 状态改变就会调用
        ajax.onreadystatechange = function () {
            if (ajax.readyState == 4 && ajax.status == 200) {
                //步骤五 如果能够进到这个判断 说明 数据 完美的回来了,并且请求的页面是存在的
                const res = JSON.parse(ajax.responseText)
                let lang = localStorage.getItem('lang') || 'zh-CN'
                if (lang == 'zh-CN') {
                    document.title = res.shorthand
                } else {
                    document.title = res.desc
                }

                if (res.ico) {
                    const icon = JSON.parse(res.ico)
                    // getIcon(icon[0].id)
                }
            }
        }
    }

    function getIcon(id) {
        let link = document.createElement('link')
        link.type = 'image/x-icon'
        link.rel = 'shortcut icon'
        const ajax = new XMLHttpRequest()
        const url =
            window.config.API_BASE_URL + '/file/onlinePreviewController/v1/getFileById_' + id
        ajax.responseType = 'arraybuffer'
        ajax.open('get', url)
        //步骤三:发送请求
        ajax.send()
        ajax.onload = function () {
            //处理数据
            if (ajax.status == 200) {
                const indexIco = window.URL.createObjectURL(
                    new Blob([ajax.response], {
                        type: 'arraybuffer'
                    })
                )
                link.href = indexIco
                document.getElementsByTagName('head')[0].appendChild(link)
            }
        }
    }

    title()
})(window, document)
