/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.portal.model.SysIndexColumn;
import com.artfess.portal.model.SysIndexMyLayout;
import com.artfess.portal.persistence.dao.SysIndexMyLayoutDao;
import com.artfess.portal.persistence.manager.SysIndexColumnManager;
import com.artfess.portal.persistence.manager.SysIndexLayoutManageManager;
import com.artfess.portal.persistence.manager.SysIndexMyLayoutManager;
import com.artfess.portal.util.PortalUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="sysIndexMyLayoutManager")
public class SysIndexMyLayoutManagerImpl
extends BaseManagerImpl<SysIndexMyLayoutDao, SysIndexMyLayout>
implements SysIndexMyLayoutManager {
    @Resource
    SysIndexLayoutManageManager sysIndexLayoutManageManager;
    @Resource
    SysIndexColumnManager sysIndexColumnManager;

    private String defaultIndexLayout() {
        String templateHtml = FileUtil.readFile((String)(PortalUtil.getIndexTemplatePath() + "templates" + File.separator + "defaultIndexPages.ftl"));
        return templateHtml;
    }

    @Override
    public SysIndexMyLayout getLayoutList(String userId, List<SysIndexColumn> columnList) {
        SysIndexMyLayout sysIndexMyLayout = ((SysIndexMyLayoutDao)this.baseMapper).getByUserId(userId);
        if (BeanUtils.isEmpty((Object)((Object)sysIndexMyLayout))) {
            return this.getDefaultIndexLayout();
        }
        String designHtml = "";
        try {
            designHtml = Base64.getFromBase64((String)sysIndexMyLayout.getDesignHtml());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sysIndexMyLayout.setDesignHtml(this.sysIndexColumnManager.parserDesignHtml(designHtml, columnList));
        return sysIndexMyLayout;
    }

    private SysIndexMyLayout getDefaultIndexLayout() {
        SysIndexMyLayout sysIndexMyLayout = new SysIndexMyLayout();
        sysIndexMyLayout.setDesignHtml(this.sysIndexLayoutManageManager.getDefaultDesignHtml());
        return sysIndexMyLayout;
    }

    @Override
    public void save(String html, String designHtml, String userId) {
        SysIndexMyLayout sysIndexMyLayout = ((SysIndexMyLayoutDao)this.baseMapper).getByUserId(userId);
        if (BeanUtils.isEmpty((Object)((Object)sysIndexMyLayout))) {
            sysIndexMyLayout = new SysIndexMyLayout();
            sysIndexMyLayout.setDesignHtml(designHtml);
            sysIndexMyLayout.setTemplateHtml(html);
            sysIndexMyLayout.setId(UniqueIdUtil.getSuid());
            sysIndexMyLayout.setUserId(userId);
            this.create((Model)sysIndexMyLayout);
        } else {
            sysIndexMyLayout.setDesignHtml(designHtml);
            sysIndexMyLayout.setTemplateHtml(html);
            this.update((Model)sysIndexMyLayout);
        }
    }

    @Override
    public String obtainMyIndexData(String userId) {
        SysIndexMyLayout sysIndexMyLayout = ((SysIndexMyLayoutDao)this.baseMapper).getByUserId(userId);
        if (BeanUtils.isNotEmpty((Object)((Object)sysIndexMyLayout))) {
            return sysIndexMyLayout.getTemplateHtml();
        }
        String html = this.sysIndexLayoutManageManager.getMyHasRightsLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        html = this.sysIndexLayoutManageManager.getManagerLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        return "";
    }

    @Override
    public SysIndexMyLayout getByUser(String currentUserId) {
        return ((SysIndexMyLayoutDao)this.baseMapper).getByUserId(currentUserId);
    }

    @Override
    public String obtainIndexMyData(String layoutId) {
        SysIndexMyLayout sysIndexMyLayout = (SysIndexMyLayout)this.get((Serializable)((Object)layoutId));
        if (BeanUtils.isNotEmpty((Object)((Object)sysIndexMyLayout))) {
            return sysIndexMyLayout.getTemplateHtml();
        }
        String html = this.sysIndexLayoutManageManager.getMyHasRightsLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        html = this.sysIndexLayoutManageManager.getManagerLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        if (BeanUtils.isEmpty((Object)html)) {
            html = this.defaultIndexLayout();
        }
        return "";
    }

    @Override
    public void removeByUserId(String userId) {
        ((SysIndexMyLayoutDao)this.baseMapper).removeByUserId(userId);
    }

    @Override
    public void setValid(String id) {
        ((SysIndexMyLayoutDao)this.baseMapper).updateValid(0, ContextUtil.getCurrentUserId());
        ((SysIndexMyLayoutDao)this.baseMapper).setValid(id);
    }
}

