/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.form.model.FormTemplate;
import com.artfess.form.persistence.manager.FormTemplateManager;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/template/v1"})
@Api(tags={"\u8868\u5355\u6a21\u677f"})
@ApiGroup(group={"group_form"})
public class TemplateController
extends BaseController<FormTemplateManager, FormTemplate> {
    @Resource
    FormTemplateManager bpmFormTemplateManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6a21\u7248\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u8868\u5355\u6a21\u7248\u5217\u8868")
    public PageList<FormTemplate> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.bpmFormTemplateManager.query(queryFilter);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u8868\u5355\u6a21\u7248", httpMethod="POST", notes="\u6dfb\u52a0\u8868\u5355\u6a21\u7248")
    public CommonResult save(@ApiParam(name="bpmFormTemplate", value="\u8868\u5355\u6a21\u7248\u5bf9\u8c61", required=true) @RequestBody FormTemplate bpmFormTemplate) throws Exception {
        FormTemplate template;
        String templateId = bpmFormTemplate.getTemplateId();
        bpmFormTemplate.setIsDefault(0);
        if (StringUtil.isEmpty((String)templateId)) {
            bpmFormTemplate.setId(UniqueIdUtil.getSuid());
            bpmFormTemplate.setCanedit(1);
        }
        if (BeanUtils.isEmpty((Object)((Object)(template = (FormTemplate)this.bpmFormTemplateManager.get((Serializable)((Object)templateId)))))) {
            this.bpmFormTemplateManager.create((Model)bpmFormTemplate);
            return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f", null);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", templateId);
        map.put("rev", bpmFormTemplate.getRev());
        FormTemplate bpmFormTemplate1 = this.bpmFormTemplateManager.getTemplateByRev(map);
        if (BeanUtils.isNotEmpty((Object)((Object)bpmFormTemplate1))) {
            this.bpmFormTemplateManager.update((Model)bpmFormTemplate);
            return new CommonResult(true, "\u66f4\u65b0\u6210\u529f", null);
        }
        return new CommonResult(false, "\u6b64\u6a21\u677f\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539", null);
    }

    @RequestMapping(value={"copyTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u590d\u5236\u6a21\u677f\u4fe1\u606f", httpMethod="POST", notes="\u590d\u5236\u6a21\u677f\u4fe1\u606f")
    public CommonResult copyTemplate(@ApiParam(name="templateId", value="\u8868\u5355\u6a21\u7248ID", required=true) @RequestParam String templateId, @ApiParam(name="newTemplateName", value="\u65b0\u8868\u5355\u6a21\u677f\u540d\u5b57", required=true) @RequestParam String newTemplateName, @ApiParam(name="newAlias", value="\u65b0\u8868\u5355\u6a21\u677f\u522b\u540d", required=true) @RequestParam String newAlias) throws Exception {
        FormTemplate bpmFormTemplate = (FormTemplate)this.bpmFormTemplateManager.get((Serializable)((Object)templateId));
        boolean isExist = this.bpmFormTemplateManager.isExistAlias(newAlias);
        if (isExist) {
            return new CommonResult(false, "\u8be5\u522b\u540d\u5df2\u88ab\u4f7f\u7528", null);
        }
        FormTemplate template = new FormTemplate();
        String newId = UniqueIdUtil.getSuid();
        template.setTemplateId(newId);
        template.setTemplateName(newTemplateName);
        template.setAlias(newAlias);
        template.setCanedit(1);
        template.setHtml(bpmFormTemplate.getHtml());
        template.setMacrotemplateAlias(bpmFormTemplate.getMacrotemplateAlias());
        template.setTemplateDesc(bpmFormTemplate.getTemplateDesc());
        template.setTemplateType(bpmFormTemplate.getTemplateType());
        template.setSource("custom");
        this.bpmFormTemplateManager.create((Model)template);
        return new CommonResult(true, "\u590d\u5236\u6a21\u677f\u6210\u529f", null);
    }

    @RequestMapping(value={"backUp"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5c06\u7528\u6237\u81ea\u5b9a\u4e49\u6a21\u677f\u5907\u4efd", httpMethod="POST", notes="\u5c06\u7528\u6237\u81ea\u5b9a\u4e49\u6a21\u677f\u5907\u4efd")
    public CommonResult backUp(@ApiParam(name="templateId", value="\u8868\u5355\u6a21\u7248ID", required=true) @RequestBody String templateId) throws Exception {
        this.bpmFormTemplateManager.backUpTemplate(templateId);
        return new CommonResult(true, "\u6a21\u677f\u5907\u4efd\u6210\u529f!", null);
    }

    @RequestMapping(value={"templateEdit"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u8868\u5355\u6a21\u7248\u4fe1\u606f\u9875\u9762", httpMethod="POST", notes="\u7f16\u8f91\u8868\u5355\u6a21\u7248\u4fe1\u606f\u9875\u9762")
    public CommonResult edit(@ApiParam(name="templateId", value="\u8868\u5355\u6a21\u7248ID", required=true) @RequestBody String templateId) throws Exception {
        FormTemplate bpmFormTemplate = null;
        if (StringUtil.isNotEmpty((String)templateId)) {
            bpmFormTemplate = (FormTemplate)this.bpmFormTemplateManager.get((Serializable)((Object)templateId));
        }
        List<FormTemplate> macroTemplates = this.bpmFormTemplateManager.getAllMacroTemplate();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bpmFormTemplate", (Object)bpmFormTemplate);
        map.put("macroTemplates", macroTemplates);
        return new CommonResult(true, "", map);
    }

    @RequestMapping(value={"templateGet"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u6a21\u7248\u660e\u7ec6\u9875\u9762", httpMethod="POST", notes="\u8868\u5355\u6a21\u7248\u660e\u7ec6\u9875\u9762")
    public CommonResult get(@ApiParam(name="templateId", value="\u8868\u5355\u6a21\u7248ID", required=true) @RequestBody String templateId) throws Exception {
        FormTemplate bpmFormTemplate = null;
        if (StringUtil.isNotEmpty((String)templateId)) {
            bpmFormTemplate = (FormTemplate)this.bpmFormTemplateManager.get((Serializable)((Object)templateId));
        }
        HashMap<String, FormTemplate> map = new HashMap<String, FormTemplate>();
        map.put("bpmFormTemplate", bpmFormTemplate);
        return new CommonResult(true, "", map);
    }

    @RequestMapping(value={"checkAliasIsExist"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u6a21\u677f\u522b\u540d\u662f\u5426\u552f\u4e00", httpMethod="POST", notes="\u68c0\u67e5\u6a21\u677f\u522b\u540d\u662f\u5426\u552f\u4e00")
    public CommonResult<Boolean> checkAliasIsExist(@ApiParam(name="alias", value="\u8868\u5355\u6a21\u7248\u522b\u540d", required=true) @RequestBody String alias) throws Exception {
        if (StringUtil.isEmpty((String)alias)) {
            return new CommonResult(true, "", (Object)false);
        }
        FormTemplate bpmFormTemplate = this.bpmFormTemplateManager.getByTemplateAlias(alias);
        if (BeanUtils.isEmpty((Object)((Object)bpmFormTemplate))) {
            return new CommonResult(true, "", (Object)false);
        }
        return new CommonResult(true, "", (Object)true);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8868\u5355\u6a21\u677f", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8868\u5355\u6a21\u677f")
    public CommonResult remove(@ApiParam(name="templateId", value="\u8868\u5355\u6a21\u677fID!\u591a\u4e2aID\u7528,\u5206\u5272", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = new String[]{};
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.bpmFormTemplateManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u8868\u5355\u6a21\u7248\u6210\u529f", null);
    }

    @RequestMapping(value={"init"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u5f97\u521d\u59cb\u5316\u6a21\u677f\u4fe1\u606f", httpMethod="POST", notes="\u53d6\u5f97\u521d\u59cb\u5316\u6a21\u677f\u4fe1\u606f")
    public CommonResult init() throws Exception {
        this.bpmFormTemplateManager.initAllTemplate();
        return new CommonResult(true, "\u521d\u59cb\u5316\u8868\u5355\u6a21\u677f\u6210\u529f!");
    }

    @RequestMapping(value={"selectTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9009\u62e9\u6a21\u677f", httpMethod="POST", notes="\u9009\u62e9\u6a21\u677f")
    public CommonResult selectTemplate(@ApiParam(name="defId", value="\u8868\u5355\u5143\u6570\u636eId", required=true) @RequestBody String defId, @ApiParam(name="isSimple", value="0\u6216\u80051", required=true) @RequestBody int isSimple, @ApiParam(name="templatesId", value="\u6a21\u677fid", required=true) @RequestBody String templatesId, @ApiParam(name="formType", value="\u6a21\u677f\u7c7b\u578bpc \u6216\u8005 mobile", required=false) @RequestBody String formType) throws Exception {
        Map<String, Object> map = this.bpmFormTemplateManager.selectTemplate(defId, isSimple, templatesId, formType);
        return new CommonResult(true, "\u83b7\u53d6\u6a21\u677f\u6210\u529f", map);
    }

    @RequestMapping(value={"isTemplateByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u6d4b\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="GET", notes="\u68c0\u6d4b\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    @ResponseBody
    public CommonResult<Boolean> isMethodExistByAlias(@ApiParam(name="alias", value="\u6a21\u677f\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        FormTemplate template = this.bpmFormTemplateManager.getByTemplateAlias(alias);
        CommonResult commonResult = new CommonResult();
        if (BeanUtils.isNotEmpty((Object)((Object)template))) {
            commonResult.setValue((Object)true);
        }
        return commonResult;
    }

    @RequestMapping(value={"getTemplateType"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6a21\u7248\u7c7b\u578b\u53d6\u5f97\u6a21\u7248\u5217\u8868\u3002", httpMethod="GET", notes="\u6839\u636e\u6a21\u7248\u7c7b\u578b\u53d6\u5f97\u6a21\u7248\u5217\u8868\u3002")
    public Map<String, Object> getTemplateType() throws Exception {
        return this.bpmFormTemplateManager.getTemplateTypeMap("main", "macro", "subTable");
    }

    @RequestMapping(value={"setDefault"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u6a21\u677f", httpMethod="GET", notes="\u8bbe\u7f6e\u9ed8\u8ba4\u6a21\u677f")
    @ResponseBody
    public CommonResult setDefault(@ApiParam(name="id", value="\u6a21\u677fid", required=true) @RequestParam String id, @ApiParam(name="type", value="\u6a21\u677f\u7c7b\u578b", required=true) @RequestParam String type) throws Exception {
        this.bpmFormTemplateManager.setDefault(id, type);
        return new CommonResult(true, "\u66f4\u65b0\u6210\u529f");
    }
}

