/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.manager.impl;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.persistence.util.PublishAutoTestEventUtil;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.workflow.runtime.manager.impl.BpmTestCaseManagerImpl;
import com.artfess.workflow.runtime.model.BpmTestCase;
import com.artfess.workflow.runtime.params.StartFlowParamObject;
import com.artfess.workflow.runtime.params.StartResult;
import java.time.LocalDateTime;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

class MyCallable
implements Callable<Object> {
    private Logger logger = LoggerFactory.getLogger(BpmTestCaseManagerImpl.class);
    private BpmTestCase bpmTestCase;
    private String account;
    Authentication authentication;

    MyCallable(BpmTestCase bpmTestCase, String account, Authentication authentication) {
        this.bpmTestCase = bpmTestCase;
        this.account = account;
        this.authentication = authentication;
    }

    @Override
    public Object call() throws Exception {
        this.logger.info(">>>" + this.account + "\u542f\u52a8\u6d41\u7a0b\u4eff\u771f");
        LocalDateTime dateTmp1 = LocalDateTime.now();
        String instId = this.startFlow();
        Thread.sleep(200L);
        LocalDateTime dateTmp2 = LocalDateTime.now();
        long time = TimeUtil.getTimeMillis((LocalDateTime)dateTmp2) - TimeUtil.getTimeMillis((LocalDateTime)dateTmp1);
        this.logger.info(">>>" + this.account + "\u4efb\u52a1\u7ec8\u6b62; \u82b1\u8d39\u65f6\u95f4\u4e3a\uff1a " + time);
        return instId;
    }

    private String startFlow() {
        StartFlowParamObject startFlowParamObject = new StartFlowParamObject();
        startFlowParamObject.setAccount(this.account);
        startFlowParamObject.setFlowKey(this.bpmTestCase.getDefKey());
        try {
            startFlowParamObject.setData(Base64.getBase64((String)this.bpmTestCase.getBoFormData()));
            startFlowParamObject.setSysCode("bpmx_test_" + this.bpmTestCase.getId());
            IProcessManager processService = (IProcessManager)AppUtil.getBean(IProcessManager.class);
            SecurityContextHolder.getContext().setAuthentication(this.authentication);
            CompletableFuture<StartResult> start2 = processService.start(startFlowParamObject);
            StartResult start = start2.get();
            if (start.getState().booleanValue() && StringUtil.isNotEmpty((String)start.getInstId())) {
                this.logger.debug("instId:" + start.getInstId());
                PublishAutoTestEventUtil.publishAutoTestEvent((String)start.getInstId());
                return start.getInstId();
            }
            throw new RuntimeException("\u542f\u52a8\u6d41\u7a0b\u4eff\u771f\u6d4b\u8bd5\u5931\u8d25");
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return "";
        }
    }
}

