/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.params;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.model.BpmIdentityResult;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.util.ServiceUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@ApiModel(value="\u6d41\u7a0b\u4efb\u52a1")
public class BpmTaskResult {
    @ApiModelProperty(name="taskId", notes="\u4efb\u52a1ID", example="10000000000001", required=true)
    protected String taskId;
    @ApiModelProperty(name="taskName", notes="\u4efb\u52a1\u540d\u79f0", example="\u7ecf\u7406\u5ba1\u6279", required=true)
    protected String taskName;
    @ApiModelProperty(name="subject", notes="\u6d41\u7a0b\u5b9e\u4f8b\u6807\u9898", example="\u7ecf\u7406\u5ba1\u6279", required=true)
    protected String subject;
    @ApiModelProperty(name="nodeId", notes="\u4efb\u52a1\u6240\u5c5e\u8282\u70b9ID", example="managerApproval", required=true)
    protected String nodeId;
    @ApiModelProperty(name="flowKey", notes="\u6d41\u7a0b\u5b9a\u4e49KEY", example="qjlc", required=true)
    protected String flowKey;
    @ApiModelProperty(name="flowName", notes="\u6d41\u7a0b\u540d\u79f0", example="\u8bf7\u5047\u6d41\u7a0b", required=true)
    protected String flowName;
    @ApiModelProperty(name="status", notes="\u4efb\u52a1\u72b6\u6001", allowableValues="NORMAL(\u666e\u901a\u4efb\u52a1),AGENT(\u4ee3\u7406\u4efb\u52a1),DELIVERTO(\u8f6c\u529e\u4efb\u52a1),TRANSFORMING(\u6d41\u8f6c\u6e90\u4efb\u52a1),TRANSFORMED(\u63a5\u6536\u6d41\u8f6c\u4efb\u52a1),COMMU(\u901a\u77e5\u4efb\u52a1),BACK(\u88ab\u9a73\u56de\u4efb\u52a1),ADDSIGN(\u52a0\u7b7e)", example="NORMAL", required=true)
    protected String status;
    @ApiModelProperty(name="dueTime", notes="\u4efb\u52a1\u5230\u671f\u65f6\u95f4", example="2017-10-17 12:18:00", required=true)
    protected LocalDateTime dueTime;
    @ApiModelProperty(name="suspendState", notes="\u662f\u5426\u6302\u8d77", allowableValues="0(\u6b63\u5e38),1(\u6302\u8d77)", example="0", required=true)
    protected Short suspendState;
    @ApiModelProperty(name="typeId", notes="\u4efb\u52a1\u7c7b\u578bID", required=true)
    protected String typeId = "";
    @ApiModelProperty(name="creator", notes="\u4efb\u52a1\u521b\u5efa\u4eba", required=true)
    protected BpmIdentityResult creator = null;
    @ApiModelProperty(name="assignee", notes="\u4efb\u52a1\u6267\u884c\u4eba", required=true)
    protected BpmIdentityResult assignee = null;
    @ApiModelProperty(name="candidate", notes="\u4efb\u52a1\u5019\u9009\u4eba", required=true)
    protected List<BpmIdentityResult> candidate = null;
    @ApiModelProperty(name="createDate", notes="\u4efb\u52a1\u521b\u5efa\u65f6\u95f4", required=true)
    protected LocalDateTime createDate;

    public BpmTaskResult(DefaultBpmTask defaultBpmTask) throws Exception {
        List extractUser;
        List identityList;
        String assigneeId;
        if (BeanUtils.isEmpty((Object)defaultBpmTask)) {
            throw new RuntimeException("\u6d41\u7a0b\u4efb\u52a1\u4e3a\u7a7a");
        }
        this.taskId = defaultBpmTask.getId();
        this.taskName = defaultBpmTask.getName();
        this.subject = defaultBpmTask.getSubject();
        this.nodeId = defaultBpmTask.getNodeId();
        this.flowKey = defaultBpmTask.getProcDefKey();
        this.flowName = defaultBpmTask.getProcDefName();
        this.status = defaultBpmTask.getStatus();
        this.dueTime = defaultBpmTask.getDueTime();
        this.suspendState = defaultBpmTask.getSuspendState();
        this.typeId = defaultBpmTask.getTypeId();
        this.createDate = defaultBpmTask.getCreateDate();
        String creatorId = defaultBpmTask.getCreatorId();
        if (StringUtil.isNotEmpty((String)creatorId)) {
            IUser creatorUser = ServiceUtil.getUserById((String)creatorId);
            this.creator = new BpmIdentityResult(creatorUser);
        }
        if (StringUtil.isNotZeroEmpty((String)(assigneeId = defaultBpmTask.getAssigneeId()))) {
            IUser assigneeUser = ServiceUtil.getUserById((String)assigneeId);
            this.assignee = new BpmIdentityResult(assigneeUser);
        }
        if (BeanUtils.isNotEmpty((Object)(identityList = defaultBpmTask.getIdentityList())) && BeanUtils.isNotEmpty((Object)(extractUser = ServiceUtil.extractUser((List)identityList)))) {
            this.candidate = new ArrayList<BpmIdentityResult>();
            for (IUser iUser : extractUser) {
                this.candidate.add(new BpmIdentityResult(iUser));
            }
        }
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getFlowKey() {
        return this.flowKey;
    }

    public void setFlowKey(String flowKey) {
        this.flowKey = flowKey;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public LocalDateTime getDueTime() {
        return this.dueTime;
    }

    public void setDueTime(LocalDateTime dueTime) {
        this.dueTime = dueTime;
    }

    public Short getSuspendState() {
        return this.suspendState;
    }

    public void setSuspendState(Short suspendState) {
        this.suspendState = suspendState;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public BpmIdentityResult getCreator() {
        return this.creator;
    }

    public void setCreator(BpmIdentityResult creator) {
        this.creator = creator;
    }

    public BpmIdentityResult getAssignee() {
        return this.assignee;
    }

    public void setAssignee(BpmIdentityResult assignee) {
        this.assignee = assignee;
    }

    public List<BpmIdentityResult> getCandidate() {
        return this.candidate;
    }

    public void setCandidate(List<BpmIdentityResult> candidate) {
        this.candidate = candidate;
    }

    public LocalDateTime getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }
}

