package com.artfess.workflow.runtime.model;
import org.apache.commons.lang.builder.ToStringBuilder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import java.time.LocalDateTime;


 /**
 * 流程仿真异常日志
 * <pre> 
 * 描述：流程仿真异常日志 实体对象
 * 构建组：x7
 * 作者:heyf
 * 邮箱:heyf@jee-soft.cn
 * 日期:2020-11-04 17:14:52
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
 @TableName("BPM_TEST_CASE_LOGS")
 @ApiModel(value = "BpmTestCaseLogs",description = "流程仿真异常日志") 
public class BpmTestCaseLogs extends BaseModel<BpmTestCaseLogs>{

	private static final long serialVersionUID = 1L;
	@XmlTransient
	@TableId("ID_")
	@ApiModelProperty(value="ID_")
	protected String id; 
	
	@XmlAttribute(name = "opeName")
	@TableField("OPE_NAME_")
	@ApiModelProperty(value="操作名称")
	protected String opeName; 
	
	@XmlAttribute(name = "executionTime")
	@TableField("EXECUTION_TIME_")
	@ApiModelProperty(value="EXECUTION_TIME_")
	protected LocalDateTime executionTime; 
	
	@XmlAttribute(name = "opeContent")
	@TableField("OPE_CONTENT_")
	@ApiModelProperty(value="操作内容")
	protected String opeContent; 
	
	@XmlAttribute(name = "tenantId")
	@TableField("TENANT_ID_")
	@ApiModelProperty(value="TENANT_ID_")
	protected String tenantId; 
	
	
	public void setId(String id) {
		this.id = id;
	}
	
	/**
	 * 返回 ID_
	 * @return
	 */
	public String getId() {
		return this.id;
	}
	public void setOpeName(String opeName) {
		this.opeName = opeName;
	}
	
	/**
	 * 返回 操作名称
	 * @return
	 */
	public String getOpeName() {
		return this.opeName;
	}
	public void setExecutionTime(LocalDateTime executionTime) {
		this.executionTime = executionTime;
	}
	
	/**
	 * 返回 EXECUTION_TIME_
	 * @return
	 */
	public LocalDateTime getExecutionTime() {
		return this.executionTime;
	}
	public void setOpeContent(String opeContent) {
		this.opeContent = opeContent;
	}
	
	/**
	 * 返回 操作内容
	 * @return
	 */
	public String getOpeContent() {
		return this.opeContent;
	}
	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}
	
	/**
	 * 返回 TENANT_ID_
	 * @return
	 */
	public String getTenantId() {
		return this.tenantId;
	}
	/**
	 * @see Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this)
		.append("id", this.id) 
		.append("opeName", this.opeName) 
		.append("executionTime", this.executionTime) 
		.append("opeContent", this.opeContent) 
		.append("tenantId", this.tenantId) 
		.toString();
	}
}